/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancylib.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class UUIDFetcher {
    public static final long FEBRUARY_2015 = 1422748800000L;
    private static final ExtendedFancyLogger LOGGER = new ExtendedFancyLogger("UUIDFetcher");
    private static final String UUID_URL = "https://api.minecraftservices.com/users/profiles/minecraft/%s?at=%d";
    private static final String NAME_URL = "https://api.minecraftservices.com/user/profile/%s";
    private static Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).create();
    private static Map<String, UUID> uuidCache = new HashMap<String, UUID>();
    private static Map<UUID, String> nameCache = new HashMap<UUID, String>();
    private static ExecutorService pool = Executors.newCachedThreadPool();
    private String name;
    private UUID id;

    public static void getUUID(String name, Consumer<UUID> action) {
        pool.execute(() -> action.accept(UUIDFetcher.getUUID(name)));
    }

    public static UUID getUUID(String name) {
        return UUIDFetcher.getUUIDAt(name, System.currentTimeMillis());
    }

    public static void getUUIDAt(String name, long timestamp, Consumer<UUID> action) {
        pool.execute(() -> action.accept(UUIDFetcher.getUUIDAt(name, timestamp)));
    }

    public static UUID getUUIDAt(String name, long timestamp) {
        if (uuidCache.containsKey(name = name.toLowerCase())) {
            return uuidCache.get(name);
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(UUID_URL, name, timestamp / 1000L)).openConnection();
            connection.setReadTimeout(5000);
            UUIDFetcher data = gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher.class);
            uuidCache.put(name, data.id);
            nameCache.put(data.id, data.name);
            return data.id;
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch UUID for name: " + name, ThrowableProperty.of(e));
            return null;
        }
    }

    public static void getName(UUID uuid, Consumer<String> action) {
        pool.execute(() -> action.accept(UUIDFetcher.getName(uuid)));
    }

    public static String getName(UUID uuid) {
        if (nameCache.containsKey(uuid)) {
            return nameCache.get(uuid);
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(NAME_URL, UUIDTypeAdapter.fromUUID(uuid))).openConnection();
            connection.setReadTimeout(5000);
            UUIDFetcher currentNameData = gson.fromJson((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), UUIDFetcher.class);
            uuidCache.put(currentNameData.name.toLowerCase(), uuid);
            nameCache.put(uuid, currentNameData.name);
            return currentNameData.name;
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch name for uuid: " + String.valueOf(uuid), ThrowableProperty.of(e));
            return null;
        }
    }
}

