/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.dialog;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.data.DialogBodyData;
import com.fancyinnovations.fancydialogs.api.data.DialogButton;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogCheckbox;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogInput;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogSelect;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogTextField;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancysitula.api.dialogs.FS_CommonDialogData;
import de.oliver.fancysitula.api.dialogs.FS_Dialog;
import de.oliver.fancysitula.api.dialogs.FS_DialogAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_CommonButtonData;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogActionButton;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogActionButtonAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogCopyToClipboardAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogCustomAction;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogBody;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogTextBody;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogBooleanInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInputControl;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogSingleOptionInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogTextInput;
import de.oliver.fancysitula.api.dialogs.types.FS_MultiActionDialog;
import de.oliver.fancysitula.api.dialogs.types.FS_NoticeDialog;
import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.factories.FancySitula;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.lushplugins.chatcolorhandler.ChatColorHandler;
import org.lushplugins.chatcolorhandler.parsers.ParserTypes;

public class DialogImpl
extends Dialog {
    public DialogImpl(String id, DialogData data) {
        super(id, data);
    }

    private String replaceArgs(String text, String[] args) {
        if (args == null || args.length == 0 || text == null) {
            return text;
        }
        String result = text;
        for (int i = 0; i < args.length; ++i) {
            result = result.replace("{arg:" + i + "}", args[i] != null ? args[i] : "");
        }
        return result;
    }

    private FS_Dialog buildForPlayer(Player player, String[] args) {
        ArrayList<FS_DialogBody> body = new ArrayList<FS_DialogBody>();
        for (DialogBodyData dialogBodyData : this.data.body()) {
            int textWidth = dialogBodyData.width() != null && dialogBodyData.width() > 0 ? dialogBodyData.width() : 200;
            String bodyText = this.replaceArgs(dialogBodyData.text(), args);
            FS_DialogTextBody fsDialogTextBody = new FS_DialogTextBody(ChatColorHandler.translate(bodyText, player, ParserTypes.placeholder()), textWidth);
            body.add(fsDialogTextBody);
        }
        ArrayList<FS_DialogInput> inputs = new ArrayList<FS_DialogInput>();
        if (this.data.inputs() != null) {
            for (DialogInput input : this.data.inputs().all()) {
                FS_DialogInputControl control = null;
                if (input instanceof DialogTextField) {
                    DialogTextField textField = (DialogTextField)input;
                    String label = this.replaceArgs(textField.getLabel(), args);
                    String placeholder = this.replaceArgs(textField.getPlaceholder(), args);
                    control = new FS_DialogTextInput(200, ChatColorHandler.translate(label, player, ParserTypes.placeholder()), !label.isEmpty(), ChatColorHandler.translate(placeholder, player, ParserTypes.placeholder()), textField.getMaxLength(), textField.getMaxLines() > 0 ? new FS_DialogTextInput.MultilineOptions(textField.getMaxLines(), null) : null);
                } else if (input instanceof DialogSelect) {
                    DialogSelect select = (DialogSelect)input;
                    ArrayList<FS_DialogSingleOptionInput.Entry> entries = new ArrayList<FS_DialogSingleOptionInput.Entry>();
                    for (DialogSelect.Entry entry : select.getOptions()) {
                        entries.add(new FS_DialogSingleOptionInput.Entry(ChatColorHandler.translate(this.replaceArgs(entry.value(), args), player, ParserTypes.placeholder()), ChatColorHandler.translate(this.replaceArgs(entry.display(), args), player, ParserTypes.placeholder()), entry.initial()));
                    }
                    String selectLabel = this.replaceArgs(select.getLabel(), args);
                    control = new FS_DialogSingleOptionInput(200, entries, ChatColorHandler.translate(selectLabel, player, ParserTypes.placeholder()), !selectLabel.isEmpty());
                } else if (input instanceof DialogCheckbox) {
                    DialogCheckbox checkbox = (DialogCheckbox)input;
                    String checkboxLabel = this.replaceArgs(input.getLabel(), args);
                    control = new FS_DialogBooleanInput(checkboxLabel, checkbox.isInitial(), "true", "false");
                }
                if (control == null) {
                    throw new IllegalArgumentException("Unsupported input type: " + input.getClass().getSimpleName());
                }
                FS_DialogInput fsDialogInput = new FS_DialogInput(input.getKey(), control);
                inputs.add(fsDialogInput);
            }
        }
        ArrayList<FS_DialogActionButton> arrayList = new ArrayList<FS_DialogActionButton>();
        for (DialogButton button : this.data.buttons()) {
            FS_DialogActionButtonAction buttonAction;
            if (button.actions().size() == 1 && button.actions().get(0).name().equals("copy_to_clipboard")) {
                String clipboardData = this.replaceArgs(button.actions().get(0).data(), args);
                String text = ChatColorHandler.translate(clipboardData, player, ParserTypes.placeholder());
                buttonAction = new FS_DialogCopyToClipboardAction(text);
            } else {
                HashMap<String, String> payload = new HashMap<String, String>();
                payload.put("dialog_id", this.id);
                payload.put("button_id", button.id());
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        payload.put("arg:" + i, args[i] != null ? args[i] : "");
                    }
                }
                buttonAction = new FS_DialogCustomAction("fancydialogs_dialog_action", payload);
            }
            String buttonLabel = this.replaceArgs(button.label(), args);
            String buttonTooltip = this.replaceArgs(button.tooltip(), args);
            FS_DialogActionButton fsDialogActionButton = new FS_DialogActionButton(new FS_CommonButtonData(ChatColorHandler.translate(buttonLabel, player, ParserTypes.placeholder()), ChatColorHandler.translate(buttonTooltip, player, ParserTypes.placeholder()), 150), buttonAction);
            arrayList.add(fsDialogActionButton);
        }
        String title = this.replaceArgs(this.data.title(), args);
        String translatedTitle = ChatColorHandler.translate(title, player, ParserTypes.placeholder());
        if (arrayList.isEmpty()) {
            return new FS_NoticeDialog(new FS_CommonDialogData(translatedTitle, translatedTitle, this.data.canCloseWithEscape(), false, FS_DialogAction.CLOSE, body, inputs), new FS_DialogActionButton(new FS_CommonButtonData("Close", null, 150), new FS_DialogCustomAction("fancydialogs_dialog_action--none", Map.of())));
        }
        return new FS_MultiActionDialog(new FS_CommonDialogData(translatedTitle, translatedTitle, this.data.canCloseWithEscape(), false, FS_DialogAction.CLOSE, body, inputs), arrayList, null, 2);
    }

    @Override
    public void open(Player player) {
        this.open(player, new String[0]);
    }

    @Override
    public void open(Player player, String ... args) {
        FancySitula.PACKET_FACTORY.createShowDialogPacket(this.buildForPlayer(player, args)).send(new FS_RealPlayer(player));
        this.addViewer(player);
        FancyDialogsPlugin.get().getFancyLogger().debug("Opened dialog " + this.id + " for player " + player.getName(), new Property[0]);
    }

    @Override
    public void close(Player player) {
        FancySitula.PACKET_FACTORY.createClearDialogPacket().send(new FS_RealPlayer(player));
        this.removeViewer(player);
        FancyDialogsPlugin.get().getFancyLogger().debug("Closed dialog " + this.id + " for player " + player.getName(), new Property[0]);
    }

    @Override
    public boolean isOpenedFor(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        if (!this.viewers.containsKey(uuid)) {
            return false;
        }
        long openedAt = (Long)this.viewers.get(uuid);
        long now = System.currentTimeMillis();
        if (now - openedAt > (long)FancyDialogsPlugin.get().getFancyDialogsConfig().getCloseTimeout()) {
            this.viewers.remove(uuid);
            return false;
        }
        return true;
    }
}

