/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.joinedplayerscache;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.jdb.JDB;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class JoinedPlayersCache {
    private final Set<String> playersJoined = new HashSet<String>();
    private final JDB jdb = new JDB("plugins/FancyDialogs/data");

    public void load() {
        try {
            this.playersJoined.clear();
            String[] data = this.jdb.get("joined_players", String[].class);
            if (data != null) {
                Collections.addAll(this.playersJoined, data);
                FancyDialogsPlugin.get().getFancyLogger().debug("Loaded joined players from file.", new Property[0]);
            }
        }
        catch (Exception e) {
            FancyDialogsPlugin.get().getFancyLogger().error("Failed to load joined players cache", ThrowableProperty.of(e));
        }
    }

    public void save() {
        try {
            this.jdb.set("joined_players", this.playersJoined);
            FancyDialogsPlugin.get().getFancyLogger().debug("Saved joined players cache", new Property[0]);
        }
        catch (Exception e) {
            FancyDialogsPlugin.get().getFancyLogger().error("Failed to save joined players cache", ThrowableProperty.of(e));
        }
    }

    public void clear() {
        this.playersJoined.clear();
        this.save();
    }

    public boolean checkIfPlayerJoined(UUID playerUUID) {
        return this.playersJoined.contains(playerUUID.toString());
    }

    public void addPlayer(UUID playerUUID) {
        if (this.playersJoined.add(playerUUID.toString())) {
            this.save();
        }
    }
}

