/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs.dialog;

import com.fancyinnovations.fancydialogs.FancyDialogsPlugin;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.data.DialogBodyData;
import com.fancyinnovations.fancydialogs.api.data.DialogButton;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogCheckbox;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogInput;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogSelect;
import com.fancyinnovations.fancydialogs.api.data.inputs.DialogTextField;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancysitula.api.dialogs.FS_CommonDialogData;
import de.oliver.fancysitula.api.dialogs.FS_DialogAction;
import de.oliver.fancysitula.api.dialogs.actions.FS_CommonButtonData;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogActionButton;
import de.oliver.fancysitula.api.dialogs.actions.FS_DialogCustomAction;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogBody;
import de.oliver.fancysitula.api.dialogs.body.FS_DialogTextBody;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogBooleanInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogInputControl;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogSingleOptionInput;
import de.oliver.fancysitula.api.dialogs.inputs.FS_DialogTextInput;
import de.oliver.fancysitula.api.dialogs.types.FS_MultiActionDialog;
import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.factories.FancySitula;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.lushplugins.chatcolorhandler.ChatColorHandler;
import org.lushplugins.chatcolorhandler.parsers.ParserTypes;

public class DialogImpl
extends Dialog {
    public DialogImpl(String id, DialogData data) {
        super(id, data);
    }

    private FS_MultiActionDialog buildForPlayer(Player player) {
        ArrayList<FS_DialogBody> body = new ArrayList<FS_DialogBody>();
        for (DialogBodyData dialogBodyData : this.data.body()) {
            FS_DialogTextBody fsDialogTextBody = new FS_DialogTextBody(ChatColorHandler.translate(dialogBodyData.text(), player, ParserTypes.placeholder()), 200);
            body.add(fsDialogTextBody);
        }
        ArrayList<FS_DialogInput> inputs = new ArrayList<FS_DialogInput>();
        if (this.data.inputs() != null) {
            for (DialogInput input : this.data.inputs().all()) {
                FS_DialogInputControl control = null;
                if (input instanceof DialogTextField) {
                    DialogTextField textField = (DialogTextField)input;
                    control = new FS_DialogTextInput(200, ChatColorHandler.translate(textField.getLabel(), player, ParserTypes.placeholder()), !textField.getLabel().isEmpty(), ChatColorHandler.translate(textField.getPlaceholder(), player, ParserTypes.placeholder()), textField.getMaxLength(), textField.getMaxLines() > 0 ? new FS_DialogTextInput.MultilineOptions(textField.getMaxLines(), null) : null);
                } else if (input instanceof DialogSelect) {
                    DialogSelect select = (DialogSelect)input;
                    ArrayList<FS_DialogSingleOptionInput.Entry> entries = new ArrayList<FS_DialogSingleOptionInput.Entry>();
                    for (DialogSelect.Entry entry : select.getOptions()) {
                        entries.add(new FS_DialogSingleOptionInput.Entry(ChatColorHandler.translate(entry.value(), player, ParserTypes.placeholder()), ChatColorHandler.translate(entry.display(), player, ParserTypes.placeholder()), entry.initial()));
                    }
                    control = new FS_DialogSingleOptionInput(200, entries, ChatColorHandler.translate(select.getLabel(), player, ParserTypes.placeholder()), !select.getLabel().isEmpty());
                } else if (input instanceof DialogCheckbox) {
                    DialogCheckbox checkbox = (DialogCheckbox)input;
                    control = new FS_DialogBooleanInput(input.getLabel(), checkbox.isInitial(), "true", "false");
                }
                if (control == null) {
                    throw new IllegalArgumentException("Unsupported input type: " + input.getClass().getSimpleName());
                }
                FS_DialogInput fsDialogInput = new FS_DialogInput(input.getKey(), control);
                inputs.add(fsDialogInput);
            }
        }
        ArrayList<FS_DialogActionButton> arrayList = new ArrayList<FS_DialogActionButton>();
        for (DialogButton button : this.data.buttons()) {
            FS_DialogActionButton fsDialogActionButton = new FS_DialogActionButton(new FS_CommonButtonData(ChatColorHandler.translate(button.label(), player, ParserTypes.placeholder()), ChatColorHandler.translate(button.tooltip(), player, ParserTypes.placeholder()), 150), new FS_DialogCustomAction("fancydialogs_dialog_action", Map.of("dialog_id", this.id, "button_id", button.id())));
            arrayList.add(fsDialogActionButton);
        }
        return new FS_MultiActionDialog(new FS_CommonDialogData(ChatColorHandler.translate(this.data.title(), player, ParserTypes.placeholder()), ChatColorHandler.translate(this.data.title(), player, ParserTypes.placeholder()), this.data.canCloseWithEscape(), false, FS_DialogAction.CLOSE, body, inputs), arrayList, null, 2);
    }

    @Override
    public void open(Player player) {
        FancySitula.PACKET_FACTORY.createShowDialogPacket(this.buildForPlayer(player)).send(new FS_RealPlayer(player));
        this.addViewer(player);
        FancyDialogsPlugin.get().getFancyLogger().debug("Opened dialog " + this.id + " for player " + player.getName(), new Property[0]);
    }

    @Override
    public void close(Player player) {
        FancySitula.PACKET_FACTORY.createClearDialogPacket().send(new FS_RealPlayer(player));
        this.removeViewer(player);
        FancyDialogsPlugin.get().getFancyLogger().debug("Closed dialog " + this.id + " for player " + player.getName(), new Property[0]);
    }

    @Override
    public boolean isOpenedFor(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        if (!this.viewers.containsKey(uuid)) {
            return false;
        }
        long openedAt = (Long)this.viewers.get(uuid);
        long now = System.currentTimeMillis();
        if (now - openedAt > FancyDialogsPlugin.get().getFancyDialogsConfig().getCloseTimeout()) {
            this.viewers.remove(uuid);
            return false;
        }
        return true;
    }
}

