/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancydialogs;

import com.fancyinnovations.fancydialogs.actions.ActionRegistryImpl;
import com.fancyinnovations.fancydialogs.analytics.Analytics;
import com.fancyinnovations.fancydialogs.api.Dialog;
import com.fancyinnovations.fancydialogs.api.DialogActionRegistry;
import com.fancyinnovations.fancydialogs.api.FancyDialogs;
import com.fancyinnovations.fancydialogs.api.data.DialogData;
import com.fancyinnovations.fancydialogs.commands.DialogCMD;
import com.fancyinnovations.fancydialogs.commands.FancyDialogsCMD;
import com.fancyinnovations.fancydialogs.commands.QuickActionsCMD;
import com.fancyinnovations.fancydialogs.commands.types.DialogCommandType;
import com.fancyinnovations.fancydialogs.config.FDFeatureFlags;
import com.fancyinnovations.fancydialogs.config.FancyDialogsConfig;
import com.fancyinnovations.fancydialogs.dialog.DialogImpl;
import com.fancyinnovations.fancydialogs.fancynpcs.OpenDialogNpcAction;
import com.fancyinnovations.fancydialogs.joinedplayerscache.JoinedPlayersCache;
import com.fancyinnovations.fancydialogs.listener.DialogButtonClickedListener;
import com.fancyinnovations.fancydialogs.listener.PlayerDeathListener;
import com.fancyinnovations.fancydialogs.listener.PlayerJoinListener;
import com.fancyinnovations.fancydialogs.listener.PlayerQuitListener;
import com.fancyinnovations.fancydialogs.registry.DefaultDialogs;
import com.fancyinnovations.fancydialogs.registry.DialogRegistry;
import com.fancyinnovations.fancydialogs.storage.DialogStorage;
import com.fancyinnovations.fancydialogs.storage.JsonDialogStorage;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancyanalytics.logger.appender.ConsoleAppender;
import de.oliver.fancyanalytics.logger.appender.JsonAppender;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancylib.VersionConfig;
import de.oliver.fancylib.logging.PluginMiddleware;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancylib.translations.Language;
import de.oliver.fancylib.translations.TextConfig;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.versionFetcher.MasterVersionFetcher;
import de.oliver.fancylib.versionFetcher.VersionFetcher;
import de.oliver.fancysitula.api.IFancySitula;
import de.oliver.fancysitula.api.utils.ServerVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;

public class FancyDialogsPlugin
extends JavaPlugin
implements FancyDialogs {
    private static FancyDialogsPlugin INSTANCE;
    private final ExtendedFancyLogger fancyLogger;
    private FancyDialogsConfig fdConfig;
    private VersionFetcher versionFetcher;
    private VersionConfig versionConfig;
    private Translator translator;
    private DialogRegistry dialogRegistry;
    private DialogStorage dialogStorage;
    private ActionRegistryImpl actionRegistry;
    private JoinedPlayersCache joinedPlayersCache;

    public FancyDialogsPlugin() {
        INSTANCE = this;
        ConsoleAppender consoleAppender = new ConsoleAppender("[{loggerName}] ({threadName}) {logLevel}: {message}");
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        File logsFile = new File("plugins/FancyDialogs/logs/FD-logs-" + date + ".txt");
        if (!logsFile.exists()) {
            try {
                logsFile.getParentFile().mkdirs();
                logsFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonAppender jsonAppender = new JsonAppender(false, false, true, logsFile.getPath());
        this.fancyLogger = new ExtendedFancyLogger("FancyDialogs", LogLevel.INFO, List.of(consoleAppender, jsonAppender), List.of(new PluginMiddleware((Plugin)this)));
    }

    public static FancyDialogsPlugin get() {
        return INSTANCE;
    }

    public void onLoad() {
        this.fdConfig = new FancyDialogsConfig();
        this.fdConfig.load();
        if (!this.fdConfig.getLogLevel().equalsIgnoreCase("INFO")) {
            this.fancyLogger.setCurrentLevel(LogLevel.valueOf(this.fdConfig.getLogLevel().toUpperCase()));
        }
        FDFeatureFlags.load();
        if (FDFeatureFlags.DEBUG_MODE.isEnabled()) {
            this.fancyLogger.setCurrentLevel(LogLevel.DEBUG);
            IFancySitula.LOGGER.setCurrentLevel(LogLevel.DEBUG);
        }
        this.translator = new Translator(new TextConfig("#32e347", "#35ad1d", "#81E366", "#E3CA66", "#E36666", ""));
        this.translator.loadLanguages(this.getDataFolder().getAbsolutePath());
        Language selectedLanguage = this.translator.getLanguages().stream().filter(language -> language.getLanguageName().equals(this.fdConfig.getLanguage())).findFirst().orElse(this.translator.getFallbackLanguage());
        this.translator.setSelectedLanguage(selectedLanguage);
        this.versionFetcher = new MasterVersionFetcher(this.getName());
        this.versionConfig = new VersionConfig((Plugin)this, this.versionFetcher);
        this.versionConfig.load();
        this.dialogStorage = new JsonDialogStorage();
        Collection<DialogData> dialogData = this.dialogStorage.loadAll();
        ArrayList<DialogImpl> dialogs = new ArrayList<DialogImpl>();
        for (DialogData data : dialogData) {
            DialogImpl dialog = new DialogImpl(data.id(), data);
            dialogs.add(dialog);
            this.fancyLogger.debug("Loaded dialog: %s".formatted(data.id()), new Property[0]);
        }
        this.dialogRegistry = new DialogRegistry();
        dialogs.forEach(this.dialogRegistry::register);
        DefaultDialogs.registerDefaultDialogs();
        this.actionRegistry = new ActionRegistryImpl();
        this.joinedPlayersCache = new JoinedPlayersCache();
        this.joinedPlayersCache.load();
        this.fancyLogger.info("Successfully loaded FancyDialogs version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onEnable() {
        String version;
        ComparableVersion currentVersion = new ComparableVersion(this.versionConfig.getVersion());
        ((CompletableFuture)CompletableFuture.supplyAsync(this.versionFetcher::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(currentVersion) <= 0) {
                return;
            }
            this.fancyLogger.warn("You are not using the latest version of the FancyDialogs plugin.", new Property[0]);
            this.getLogger().warning("\n-------------------------------------------------------\nYou are not using the latest version of the FancyDialogs plugin.\nPlease update to the newest version (%s).\n%s\n-------------------------------------------------------\n".formatted(newest, this.versionFetcher.getDownloadUrl()));
        });
        if (!ServerSoftware.isPaper()) {
            this.fancyLogger.warn("--------------------------------------------------\nIt is recommended to use Paper as server software.\nBecause you are not using paper, the plugin\nmight not work correctly.\n--------------------------------------------------\n", new Property[0]);
        }
        if (ServerVersion.getByVersion(version = Bukkit.getMinecraftVersion()).getProtocolVersion() < ServerVersion.v1_21_6.getProtocolVersion()) {
            this.fancyLogger.error("--------------------------------------------------\nFancyDialogs requires Minecraft version 1.21.6 or higher.\nYour server is running version %s, which is not supported.\nPlease update your server to the latest version.\n--------------------------------------------------\n".formatted(version), new Property[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerListeners();
        this.registerCommands();
        if (Bukkit.getPluginManager().isPluginEnabled("FancyNpcs")) {
            new OpenDialogNpcAction().register();
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        Analytics analytics = new Analytics();
        analytics.start();
        this.fancyLogger.info("Successfully enabled FancyDialogs version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onDisable() {
        for (Dialog dialog : this.dialogRegistry.getAll()) {
            for (UUID viewer : dialog.getViewers()) {
                Player player = Bukkit.getPlayer((UUID)viewer);
                if (player == null || !player.isOnline()) continue;
                dialog.close(player);
            }
            this.dialogStorage.save(dialog.getData());
        }
        this.fancyLogger.info("Successfully disabled FancyDialogs version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DialogButtonClickedListener(), (Plugin)this);
    }

    private void registerCommands() {
        Lamp.Builder<BukkitCommandActor> lampBuilder = BukkitLamp.builder(this);
        lampBuilder.parameterTypes(builder -> builder.addParameterType(Dialog.class, DialogCommandType.INSTANCE));
        lampBuilder.exceptionHandler(DialogCommandType.INSTANCE);
        Lamp<BukkitCommandActor> lamp = lampBuilder.build();
        lamp.register(FancyDialogsCMD.INSTANCE);
        lamp.register(DialogCMD.INSTANCE);
        if (!FDFeatureFlags.DISABLE_QUICK_ACTIONS_DIALOG.isEnabled()) {
            lamp.register(QuickActionsCMD.INSTANCE);
        }
    }

    @Override
    public Dialog createDialog(DialogData data) {
        return new DialogImpl(data.id(), data);
    }

    public ExtendedFancyLogger getFancyLogger() {
        return this.fancyLogger;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public FancyDialogsConfig getFancyDialogsConfig() {
        return this.fdConfig;
    }

    public VersionConfig getVersionConfig() {
        return this.versionConfig;
    }

    @Override
    public DialogRegistry getDialogRegistry() {
        return this.dialogRegistry;
    }

    @Override
    public DialogActionRegistry getDialogActionRegistry() {
        return this.actionRegistry;
    }

    public DialogStorage getDialogStorage() {
        return this.dialogStorage;
    }

    public ActionRegistryImpl getActionRegistry() {
        return this.actionRegistry;
    }

    public JoinedPlayersCache getJoinedPlayersCache() {
        return this.joinedPlayersCache;
    }
}

