/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import me.notmarra.notcredits.Notcredits;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Updater {
    private final Plugin plugin;
    private final String currentVersion;
    private final String pluginName;
    private final String pluginURL;

    public Updater(Plugin plugin, String currentVersion, String pluginName, String pluginURL) {
        this.plugin = plugin;
        this.currentVersion = currentVersion;
        this.pluginName = pluginName;
        this.pluginURL = pluginURL;
    }

    public void checkForUpdates() {
        String latestVersion = this.getLatestVersion();
        if (latestVersion != null) {
            if (!this.currentVersion.equals(latestVersion)) {
                this.plugin.getLogger().warning("There is a new version of " + this.pluginName + " available! You are running version " + this.currentVersion + ", the latest version is " + latestVersion + ". Download it at " + this.pluginURL);
            } else {
                this.plugin.getLogger().info("You are running the latest version of " + this.pluginName + "!");
            }
        } else {
            this.plugin.getLogger().warning("Failed to check for updates!");
        }
    }

    private String getLatestVersion() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://raw.githubusercontent.com/notmarra/NotCredits/main/version.txt").openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            InputStream inputStream = connection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String latestVersion = bufferedReader.readLine();
            bufferedReader.close();
            inputStream.close();
            return latestVersion;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkFilesAndUpdate(String ... fileNames) {
        for (String fileName : fileNames) {
            Updater.update(fileName);
        }
    }

    private static void update(String fileName) {
        File file = new File(Notcredits.getInstance().getDataFolder(), fileName);
        if (!file.exists()) {
            Notcredits.getInstance().saveResource(fileName, false);
        } else {
            try {
                String line;
                URL url = new URL("https://raw.githubusercontent.com/NotMarra/NotCredits/main/src/main/resources/" + fileName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                InputStream inputStream = connection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append("\n");
                }
                bufferedReader.close();
                inputStream.close();
                String newFileContent = stringBuilder.toString();
                String oldFileContent = YamlConfiguration.loadConfiguration((File)file).saveToString();
                if (!newFileContent.equals(oldFileContent)) {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    ((OutputStream)outputStream).write(newFileContent.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

