/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits.commands;

import me.notmarra.notcredits.data.Database;
import me.notmarra.notcredits.utilities.Decimal;
import me.notmarra.notcredits.utilities.Messages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetCommand {
    public static void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!p.hasPermission("notcredits.set") || !p.hasPermission("notcredits.*")) {
                if (args.length == 3) {
                    String playerName = args[1];
                    Player player = Bukkit.getPlayer((String)playerName);
                    if (player != null) {
                        double amount;
                        try {
                            amount = Double.parseDouble(args[2]);
                        }
                        catch (NumberFormatException e) {
                            p.sendMessage(Messages.mm(Messages.messageGetString("not_number")));
                            return;
                        }
                        if (amount < 0.0) {
                            p.sendMessage(Messages.mm(Messages.messageGetString("not_positive_number")));
                            return;
                        }
                        Database.getInstance().setCreditsByUUID(player.getUniqueId().toString(), amount);
                        p.sendMessage(Messages.mm(Messages.messageReplaceMultiple(Messages.messageGetString("set_credits"), new String[]{"%amount%", "%player%"}, new String[]{Decimal.formatBalance(amount), playerName})));
                        player.sendMessage(Messages.mm(Messages.messageReplace(Messages.messageGetString("credits_set"), "%amount%", Decimal.formatBalance(amount))));
                    } else {
                        p.sendMessage(Messages.mm(Messages.messageGetString("invalid_use_set")));
                    }
                } else {
                    p.sendMessage(Messages.mm(Messages.messageGetString("invalid_use_set")));
                }
            }
        } else if (args.length == 3) {
            String playerName = args[1];
            Player player = Bukkit.getPlayer((String)playerName);
            if (player != null) {
                double amount;
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    Bukkit.getServer().getLogger().info("[NotCredits] Amount must be a number.");
                    return;
                }
                if (amount < 0.0) {
                    Bukkit.getServer().getLogger().info("[NotCredits] Amount must be a positive number.");
                    return;
                }
                Database.getInstance().setCreditsByUUID(player.getUniqueId().toString(), amount);
                Bukkit.getServer().getLogger().info("[NotCredits] Amount set for player.");
            } else {
                Bukkit.getServer().getLogger().info("[NotCredits] Invalid use of command.");
            }
        } else {
            Bukkit.getServer().getLogger().info("[NotCredits] Invalid use of command.");
        }
    }
}

