/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits.commands;

import me.notmarra.notcredits.data.Database;
import me.notmarra.notcredits.utilities.Decimal;
import me.notmarra.notcredits.utilities.Messages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveCommand {
    public static void execute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!p.hasPermission("notcredits.remove") || !p.hasPermission("notcredits.*")) {
                p.sendMessage(Messages.mm(Messages.messageGetString("no-perm")));
            } else if (args.length == 3) {
                String playerName = args[1];
                Player player = Bukkit.getPlayer((String)playerName);
                if (player != null) {
                    double amount;
                    try {
                        amount = Double.parseDouble(args[2]);
                    }
                    catch (NumberFormatException e) {
                        p.sendMessage(Messages.mm(Messages.messageGetString("not_number")));
                        return;
                    }
                    if (amount < 0.0) {
                        p.sendMessage(Messages.mm(Messages.messageGetString("not_positive_number")));
                        return;
                    }
                    double credits = Database.getInstance().getCreditsByUUID(player.getUniqueId().toString());
                    double final_credits = credits - amount;
                    Database.getInstance().setCreditsByUUID(player.getUniqueId().toString(), final_credits);
                    p.sendMessage(Messages.mm(Messages.messageReplaceMultiple(Messages.messageGetString("remove_credits"), new String[]{"%amount%", "%player%"}, new String[]{Decimal.formatBalance(final_credits), playerName})));
                    player.sendMessage(Messages.mm(Messages.messageReplace(Messages.messageGetString("credits_remove"), "%amount%", Decimal.formatBalance(final_credits))));
                } else {
                    p.sendMessage(Messages.mm(Messages.messageGetString("invalid_use_remove")));
                }
            } else {
                p.sendMessage(Messages.mm(Messages.messageGetString("invalid_use_remove")));
            }
        } else if (args.length == 3) {
            String playerName = args[1];
            Player player = Bukkit.getPlayer((String)playerName);
            if (player != null) {
                double amount;
                try {
                    amount = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    Bukkit.getServer().getLogger().info("[NotCredits] Amount must be a number.");
                    return;
                }
                if (amount < 0.0) {
                    Bukkit.getServer().getLogger().info("[NotCredits] Amount must be a positive number.");
                    return;
                }
                double credits = Database.getInstance().getCreditsByUUID(player.getUniqueId().toString());
                double final_credits = credits - amount;
                Database.getInstance().setCreditsByUUID(player.getUniqueId().toString(), final_credits);
                Bukkit.getServer().getLogger().info("[NotCredits] Amount removed from player.");
            } else {
                Bukkit.getServer().getLogger().info("[NotCredits] Invalid use of command.");
            }
        } else {
            Bukkit.getServer().getLogger().info("[NotCredits] Invalid use of command.");
        }
    }
}

