/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits;

import me.notmarra.notcredits.bukkit.Metrics;
import me.notmarra.notcredits.data.Database;
import me.notmarra.notcredits.listeners.Economy_NotCredits;
import me.notmarra.notcredits.listeners.Placeholders;
import me.notmarra.notcredits.listeners.Playerjoin;
import me.notmarra.notcredits.utilities.CheckDBSettings;
import me.notmarra.notcredits.utilities.CommandCreator;
import me.notmarra.notcredits.utilities.Lang;
import me.notmarra.notcredits.utilities.TabCompletion;
import me.notmarra.notcredits.utilities.Updater;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class Notcredits
extends JavaPlugin {
    private static Notcredits instance;
    FileConfiguration config;
    Updater updater = new Updater((Plugin)this, this.getDescription().getVersion(), this.getDescription().getName(), "https://www.spigotmc.org/resources/notcredits-mysql-sqlite-hexcolors-custom-currency.109773/");

    public void onEnable() {
        instance = this;
        this.config = this.getConfig();
        this.config.options().copyDefaults(true);
        this.saveDefaultConfig();
        CheckDBSettings checkDBSettings = new CheckDBSettings();
        checkDBSettings.CheckDBSettings();
        Database.getInstance().Database();
        Database.getInstance().initializeTables();
        if (this.config.getBoolean("vault")) {
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                Bukkit.getServicesManager().register(Economy.class, (Object)new Economy_NotCredits(), (Plugin)this, ServicePriority.Normal);
                Bukkit.getServer().getLogger().info("[NotCredits] Successfully connected to plugin vault!");
            } else {
                this.getLogger().warning("[NotCredits] Vault is enabled in config, but Vault not found");
                this.getLogger().warning("[NotCredits] Shutting down the plugin...");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders().register();
            Bukkit.getServer().getLogger().info("[NotCredits] Successfully loaded placeholders!");
        } else {
            Bukkit.getServer().getLogger().info("[NotCredits] PlaceholderAPI not found, not loading placeholders!");
        }
        Metrics metrics = new Metrics(this, 18464);
        Lang.createLang();
        this.getServer().getPluginManager().registerEvents((Listener)new Playerjoin(), (Plugin)this);
        this.getCommand("credits").setExecutor((CommandExecutor)new CommandCreator());
        this.getCommand("credits").setTabCompleter((TabCompleter)new TabCompletion());
        this.updater.checkForUpdates();
        Bukkit.getServer().getLogger().info("[NotCredits] Enabled successfully!");
    }

    public void onDisable() {
        Database.getInstance().disconnectFromDB();
        Bukkit.getServer().getLogger().info("[NotCredits] Disabled successfully!");
    }

    public static Notcredits getInstance() {
        return instance;
    }

    public void reload() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.getLogger().info("Plugin reloaded successfully!");
    }
}

