/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits;

import java.sql.SQLException;
import me.notmarra.notcredits.Data.Database;
import me.notmarra.notcredits.Listeners.Economy_NotCredits;
import me.notmarra.notcredits.Listeners.Placeholders;
import me.notmarra.notcredits.Listeners.PlayerJoin;
import me.notmarra.notcredits.bukkit.Metrics;
import me.notmarra.notcredits.utility.CommandCreator;
import me.notmarra.notcredits.utility.Files;
import me.notmarra.notcredits.utility.GetMessage;
import me.notmarra.notcredits.utility.TabCompletion;
import me.notmarra.notcredits.utility.Updater;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Notcredits
extends JavaPlugin {
    private Economy_NotCredits economy;
    FileConfiguration config;
    public static Notcredits main;
    String pluginVersion = this.getDescription().getVersion();
    String pluginName = this.getName();
    String serverUrl = "https://raw.githubusercontent.com/NotMarra/NotCredits/main/version.txt";
    Updater updater = new Updater((Plugin)this, this.pluginVersion, this.pluginName, this.serverUrl);

    public void onEnable() {
        this.config = this.getConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        main = this;
        if (this.config.getString("data").equalsIgnoreCase("MySQL")) {
            if (this.config.getString("mysql_hostname").equals("") || this.config.getString("mysql_port").equals("") || this.config.getString("mysql_username").equals("") || this.config.getString("mysql_database").equals("") || this.config.getString("mysql_password").equals("")) {
                this.getLogger().warning("[NotCredits] The MySQL database settings in the configuration file are not complete.");
                this.getLogger().warning("[NotCredits] Shutting down the plugin...");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else if (this.config.getString("data").equalsIgnoreCase("SQLite")) {
            if (this.config.getString("data_file").equals("")) {
                this.getLogger().warning("[NotCredits] The SQLite database settings in the configuration file are not complete.");
                this.getLogger().warning("[NotCredits] Shutting down the plugin...");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else {
            this.getLogger().warning("[NotCredits] Incorrectly set database type in configuration file.");
            this.getLogger().warning("[NotCredits] Shutting down the plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            Database.database = Database.getInstance();
            Database.database.initializeDatabase();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        Files.createFolder("lang");
        Files.createFile("lang/en.yml");
        Files.createFile("lang/cz.yml");
        this.updater.checkAndAddMissingLangStrings();
        this.getCommand("credits").setTabCompleter((TabCompleter)new TabCompletion());
        this.getCommand("credits").setExecutor((CommandExecutor)new CommandCreator(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders().register();
            Bukkit.getServer().getLogger().info("[NotCredits] Successfully loaded placeholders!");
        } else {
            Bukkit.getServer().getLogger().info("[NotCredits] PlaceholderAPI not found, not loading placeholders!");
        }
        int pluginId = 18464;
        Metrics metrics = new Metrics(this, pluginId);
        this.updater.checkForUpdates();
        Bukkit.getServer().getLogger().info("[NotCredits] Loaded successfully");
    }

    public void onDisable() {
        try {
            Database.database.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Bukkit.getServer().getLogger().info("[NotCredits] Disabled successfully!");
    }

    public static Notcredits getInstance() {
        return main;
    }

    public Database getDatabase() {
        return Database.database;
    }

    public void reload() {
        main.reloadConfig();
        String lang = main.getConfig().getString("lang", "en");
        GetMessage message = new GetMessage();
        message.setLang(lang);
        this.getLogger().info("[NotCredits] Plugin reloaded successfully!");
    }
}

