/*
 * Decompiled with CFR 0.152.
 */
package me.notmarra.notcredits.Data;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.notmarra.notcredits.Notcredits;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class Database {
    FileConfiguration config = Notcredits.main.getConfig();
    public static Database database = null;
    private Connection connection = null;

    private Database() throws SQLException {
        if (this.config.getString("data").equalsIgnoreCase("MySQL")) {
            String hostname = this.config.getString("mysql_hostname");
            String port = this.config.getString("mysql_port");
            String username = this.config.getString("mysql_username");
            String database = this.config.getString("mysql_database");
            String password = this.config.getString("mysql_password");
            String url = this.config.getString("mysql_url").replace("%hostname%", hostname).replace("%port%", port).replace("%database%", database);
            this.connection = DriverManager.getConnection(url, username, password);
            Bukkit.getServer().getLogger().info("[NotCredits] Connected to the MySQL");
        }
        if (this.config.getString("data").equalsIgnoreCase("SQLite")) {
            String databaseName = this.config.getString("data_file");
            String databasePath = Notcredits.main.getDataFolder().getAbsolutePath() + File.separator + databaseName;
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + databasePath);
            Bukkit.getServer().getLogger().info("[NotCredits] Connected to the SQLite");
        }
    }

    public static Database getInstance() throws SQLException {
        if (database == null) {
            database = new Database();
        }
        return database;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void initializeDatabase() throws SQLException {
        String table = this.config.getString("table");
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet tables = metaData.getTables(null, null, table, null);
        if (!tables.next()) {
            String sql = "CREATE TABLE IF NOT EXISTS " + table + "(uuid varchar(36) primary key, player_name varchar(36), balance long)";
            PreparedStatement stmt = this.getConnection().prepareStatement(sql);
            stmt.execute();
            stmt.close();
            Bukkit.getServer().getLogger().info("[NotCredits] Database created successfully");
        }
    }

    public String findPlayerByUUID(String uuid) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT * FROM " + table + " WHERE uuid = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setString(1, uuid);
        ResultSet results = stmt.executeQuery();
        if (results.next()) {
            String dataString = "UUID: " + uuid;
            stmt.close();
            return dataString;
        }
        stmt.close();
        return null;
    }

    public String findPlayerByPlayerName(String playerName) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT * FROM " + table + " WHERE player_name = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setString(1, playerName);
        ResultSet results = stmt.executeQuery();
        if (results.next()) {
            String dataString = "Player Name: " + playerName;
            stmt.close();
            return dataString;
        }
        stmt.close();
        return null;
    }

    public void addPlayerData(String uuid, String player_name, long balance) throws SQLException {
        String table = this.config.getString("table");
        if (this.findPlayerByUUID(uuid) != null) {
            return;
        }
        String sql = "INSERT INTO " + table + " (uuid, player_name, balance) VALUES (?, ?, ?)";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setString(1, uuid);
        stmt.setString(2, player_name);
        stmt.setLong(3, balance);
        stmt.executeUpdate();
        stmt.close();
    }

    public long getCreditsByUUID(String uuid) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT balance FROM " + table + " WHERE uuid = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setString(1, uuid);
        ResultSet results = stmt.executeQuery();
        long credits = -1L;
        if (results.next()) {
            credits = results.getLong("balance");
        }
        stmt.close();
        return credits;
    }

    public long getCreditsByPlayerName(String playerName) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT balance FROM " + table + " WHERE player_name = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setString(1, playerName);
        ResultSet results = stmt.executeQuery();
        long credits = -1L;
        if (results.next()) {
            credits = results.getLong("balance");
        }
        stmt.close();
        return credits;
    }

    public void setCreditsByUUID(String uuid, long credits) throws SQLException {
        String table = this.config.getString("table");
        String sql = "UPDATE " + table + " SET balance = ? WHERE uuid = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setLong(1, credits);
        stmt.setString(2, uuid);
        stmt.executeUpdate();
        stmt.close();
    }

    public void setCreditsByPlayerName(String playerName, long credits) throws SQLException {
        String table = this.config.getString("table");
        String sql = "UPDATE " + table + " SET balance = ? WHERE player_name = ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setLong(1, credits);
        stmt.setString(2, playerName);
        stmt.executeUpdate();
        stmt.close();
    }

    public long getCreditsByOrder(int pos) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT balance FROM " + table + " ORDER BY balance DESC LIMIT 1 OFFSET ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setInt(1, pos - 1);
        ResultSet results = stmt.executeQuery();
        long credits = -1L;
        if (results.next()) {
            credits = results.getLong("balance");
        }
        stmt.close();
        return credits;
    }

    public String getPlayerByOrder(int pos) throws SQLException {
        String table = this.config.getString("table");
        String sql = "SELECT player_name FROM " + table + " ORDER BY balance DESC LIMIT 1 OFFSET ?";
        PreparedStatement stmt = this.getConnection().prepareStatement(sql);
        stmt.setInt(1, pos - 1);
        ResultSet results = stmt.executeQuery();
        String player = "";
        if (results.next()) {
            player = results.getString("player_name");
        }
        stmt.close();
        return player;
    }
}

