/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.language.message;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.language.message.MessageOptions;
import su.nightexpress.nightcore.language.message.OutputType;
import su.nightexpress.nightcore.language.tag.MessageTag;
import su.nightexpress.nightcore.language.tag.MessageTags;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Placeholders;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.sound.AbstractSound;
import su.nightexpress.nightcore.util.text.TextRoot;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

@Deprecated
public class LangMessage {
    private final String defaultText;
    private final MessageOptions options;
    private String message;

    @Deprecated
    public LangMessage(@NotNull NightCorePlugin plugin, @NotNull String defaultText, @NotNull MessageOptions options) {
        this(defaultText, options);
    }

    @Deprecated
    public LangMessage(@NotNull NightCorePlugin plugin, @NotNull String defaultText, @NotNull MessageOptions options, @Nullable String prefix) {
        this(defaultText, options, prefix);
    }

    public LangMessage(@NotNull String defaultText, @NotNull MessageOptions options) {
        this(defaultText, options, null);
    }

    public LangMessage(@NotNull String defaultText, @NotNull MessageOptions options, @Nullable String prefix) {
        this.defaultText = defaultText;
        this.options = options;
        this.setPrefix(prefix);
    }

    @NotNull
    public LangMessage setPrefix(@NotNull NightCorePlugin plugin) {
        return this.setPrefix(plugin.getPrefix());
    }

    @NotNull
    public LangMessage setPrefix(@Nullable String prefix) {
        OutputType type = this.options.getOutputType();
        if (type != OutputType.CHAT) {
            prefix = null;
        }
        this.message = prefix == null || !this.options.hasPrefix() ? this.defaultText : prefix + this.defaultText;
        return this;
    }

    @Deprecated
    private LangMessage(@NotNull LangMessage from) {
        this.defaultText = from.defaultText;
        this.options = from.options.copy();
        this.message = from.message;
    }

    @Deprecated
    @NotNull
    public static LangMessage parse(@NotNull NightCorePlugin plugin, @NotNull String string) {
        return LangMessage.parse(string, plugin.getPrefix());
    }

    @NotNull
    public static LangMessage parse(@NotNull String string, @Nullable String defPrefix) {
        MessageOptions options = new MessageOptions();
        StringBuilder builder = new StringBuilder();
        int legTagOpen = string.indexOf("<!");
        int legTagClose = string.indexOf("!>");
        if (legTagOpen >= 0 && legTagClose > legTagOpen) {
            String[] types;
            String legContent = string.substring(legTagOpen, legTagClose + 2);
            string = string.substring(legTagClose + 2);
            for (String type : types = new String[]{"type", "sound", "prefix", "papi"}) {
                String leading;
                String typeContent;
                int typeIndex = legContent.indexOf(type + ":");
                if (typeIndex == -1 || (typeContent = StringUtil.parseQuotedContent(leading = legContent.substring(typeIndex + type.length() + 1))) == null) continue;
                if (type.equalsIgnoreCase("type")) {
                    if (typeContent.equalsIgnoreCase("action_bar")) {
                        options.setOutputType(OutputType.ACTION_BAR);
                        continue;
                    }
                    if (typeContent.equalsIgnoreCase("chat")) {
                        options.setOutputType(OutputType.CHAT);
                        continue;
                    }
                    if (typeContent.equalsIgnoreCase("none")) {
                        options.setOutputType(OutputType.NONE);
                        continue;
                    }
                    if (!typeContent.startsWith("titles")) continue;
                    String[] split = typeContent.split(":");
                    int fadeIn = NumberUtil.getAnyInteger(split[1], 20);
                    int stay = NumberUtil.getAnyInteger(split[2], 60);
                    int fadeOut = NumberUtil.getAnyInteger(split[3], 20);
                    options.setOutputType(OutputType.TITLES);
                    options.setTitleTimes(new int[]{fadeIn, stay, fadeOut});
                    continue;
                }
                if (type.equalsIgnoreCase("sound")) {
                    options.setSound(AbstractSound.deserialize(typeContent));
                    continue;
                }
                if (type.equalsIgnoreCase("prefix")) {
                    boolean b = Boolean.parseBoolean(typeContent);
                    options.setHasPrefix(b);
                    continue;
                }
                if (!type.equalsIgnoreCase("papi")) continue;
                boolean b = Boolean.parseBoolean(typeContent);
                options.setUsePlaceholderAPI(b);
            }
        }
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            char next;
            int indexEnd;
            char letter = string.charAt(index);
            if (letter == '<' && index != length - 1 && (indexEnd = ParserUtils.findUnescapedUnquotedChar(string, '>', index)) != -1 && (next = string.charAt(index + 1)) != '>') {
                MessageTag tag;
                String bracketsContent;
                String tagName = bracketsContent = string.substring(index + 1, indexEnd);
                String tagContent = null;
                int semicolonIndex = bracketsContent.indexOf(58);
                if (semicolonIndex >= 0) {
                    tagName = bracketsContent.substring(0, semicolonIndex);
                    tagContent = ParserUtils.unquoted(bracketsContent.substring(semicolonIndex + 1));
                }
                if ((tag = MessageTags.getTag(tagName)) != null) {
                    tag.apply(options, tagContent);
                    index = indexEnd;
                    continue;
                }
            }
            builder.append(letter);
        }
        String text = builder.toString();
        String prefix = options.getOutputType() == OutputType.CHAT && options.hasPrefix() ? defPrefix : null;
        StringBuilder stripper = new StringBuilder();
        for (String part : ParserUtils.breakDownLineSplitters(text)) {
            if (part.isEmpty()) continue;
            if (!stripper.isEmpty()) {
                stripper.append(TagWrappers.BR);
            }
            stripper.append(part);
        }
        String strippedText = stripper.toString();
        return new LangMessage(strippedText, options, prefix);
    }

    @NotNull
    public String getDefaultText() {
        return this.defaultText;
    }

    @Deprecated
    @NotNull
    public TextRoot getMessage() {
        return su.nightexpress.nightcore.util.text.NightMessage.from(this.message);
    }

    @NotNull
    public MessageOptions getOptions() {
        return this.options;
    }

    @Deprecated
    @NotNull
    public TextRoot getMessage(@NotNull CommandSender sender) {
        if (!this.options.usePlaceholderAPI() || !(sender instanceof Player)) {
            return this.getMessage();
        }
        Player player = (Player)sender;
        return this.getMessage().copy().replace(line -> PlaceholderAPI.setPlaceholders((Player)player, (String)line));
    }

    @Deprecated
    @NotNull
    public LangMessage replace(@NotNull String var, @NotNull Object replacer) {
        return this.replace(str -> str.replace(var, String.valueOf(replacer)));
    }

    @Deprecated
    @NotNull
    public LangMessage replace(@NotNull String var, @NotNull Consumer<List<String>> replacer) {
        ArrayList<String> list = new ArrayList<String>();
        replacer.accept(list);
        return this.replace(var, list);
    }

    @Deprecated
    @NotNull
    public LangMessage replace(@NotNull String var, @NotNull List<String> replacer) {
        return this.replace(str -> str.replace(var, String.join((CharSequence)Placeholders.TAG_LINE_BREAK, replacer)));
    }

    @Deprecated
    @NotNull
    public LangMessage replace(@NotNull UnaryOperator<String> replacer) {
        if (this.isDisabled()) {
            return this;
        }
        LangMessage copy = new LangMessage(this);
        copy.message = (String)replacer.apply(this.message);
        return copy;
    }

    public boolean isDisabled() {
        return this.options.getOutputType() == OutputType.NONE;
    }

    public void broadcast() {
        this.broadcast(null);
    }

    public void broadcast(@Nullable Consumer<Replacer> consumer) {
        if (this.isDisabled()) {
            return;
        }
        Players.getOnline().forEach(player -> this.send((CommandSender)player, consumer));
        this.send((CommandSender)Bukkit.getServer().getConsoleSender(), consumer);
    }

    public void send(@NotNull CommandSender sender) {
        this.send(sender, replacer -> {});
    }

    public void send(@NotNull CommandSender sender, @Nullable Consumer<Replacer> consumer) {
        Player player;
        if (this.isDisabled()) {
            return;
        }
        if (this.options.getSound() != null && sender instanceof Player) {
            Player player2 = (Player)sender;
            this.options.getSound().play(player2);
        }
        Replacer replacer = new Replacer();
        if (consumer != null) {
            consumer.accept(replacer);
        }
        if (this.options.usePlaceholderAPI() && sender instanceof Player) {
            player = (Player)sender;
            replacer.replacePlaceholderAPI(player);
        }
        if (this.options.getOutputType() == OutputType.CHAT) {
            Players.sendMessage(sender, NightMessage.parse(replacer.apply(this.message)));
            return;
        }
        if (sender instanceof Player) {
            player = (Player)sender;
            if (this.options.getOutputType() == OutputType.ACTION_BAR) {
                Players.sendActionBar(player, NightMessage.parse(replacer.apply(this.message)));
            } else if (this.options.getOutputType() == OutputType.TITLES) {
                String[] split = ParserUtils.breakDownLineSplitters(replacer.apply(this.message));
                String title = split[0];
                String subtitle = split.length >= 2 ? split[1] : "";
                Players.sendTitles(player, title, subtitle, this.options.getTitleTimes()[0], this.options.getTitleTimes()[1], this.options.getTitleTimes()[2]);
            }
        }
    }
}

