/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.time;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.time.TimeFormatType;

public class TimeFormats {
    private static final DateTimeFormatter DIGITAL_FULL_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter DIGITAL_SHORT_FORMATTER = DateTimeFormatter.ofPattern("mm:ss");
    private static final Map<TimeUnit, TextLocale> LITERAL_TIME_UNITS = new LinkedHashMap<TimeUnit, TextLocale>();
    private static DateTimeFormatter dateTimeFormatter;

    public static void setDateTimeFormatter(@NotNull String pattern) {
        dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
    }

    @NotNull
    public static String formatDateTime(long millis) {
        return TimeFormats.formatDateTime(TimeUtil.getLocalDateTimeOf(millis));
    }

    @NotNull
    public static String formatDateTime(@NotNull LocalDateTime time) {
        return dateTimeFormatter.format(time);
    }

    @NotNull
    public static String formatDuration(long until, @NotNull TimeFormatType formatType) {
        return TimeFormats.formatAmount(until - System.currentTimeMillis(), formatType);
    }

    @NotNull
    public static String formatSince(long since, @NotNull TimeFormatType formatType) {
        return TimeFormats.formatAmount(System.currentTimeMillis() - since, formatType);
    }

    @NotNull
    public static String formatAmount(long millis, @NotNull TimeFormatType formatType) {
        return switch (formatType) {
            default -> throw new MatchException(null, null);
            case TimeFormatType.LITERAL -> TimeFormats.toLiteral(millis);
            case TimeFormatType.DIGITAL -> TimeFormats.toDigital(millis);
            case TimeFormatType.SECONDS -> TimeFormats.toSeconds(millis);
        };
    }

    @NotNull
    public static String toSeconds(long millis) {
        long whole = TimeUnit.MILLISECONDS.toSeconds(millis);
        return whole > 0L ? String.valueOf(whole) : NumberUtil.format((double)millis / 1000.0);
    }

    @NotNull
    public static String toDigital(long millis) {
        return DIGITAL_FULL_FORMATTER.format(TimeUtil.getLocalTimeOf(millis));
    }

    @NotNull
    public static String toDigitalShort(long millis) {
        return DIGITAL_SHORT_FORMATTER.format(TimeUtil.getLocalTimeOf(millis));
    }

    @Deprecated
    @NotNull
    public static String toFormat(long millis, @NotNull DateTimeFormatter formatter) {
        return formatter.format(TimeUtil.getLocalTimeOf(millis));
    }

    @NotNull
    public static String toLiteral(long millis) {
        StringBuilder str = new StringBuilder();
        String delimiter = CoreLang.TIME_DELIMITER.text();
        long remaining = millis;
        for (Map.Entry<TimeUnit, TextLocale> entry : LITERAL_TIME_UNITS.entrySet()) {
            TimeUnit unit = entry.getKey();
            String label = entry.getValue().text();
            long value = unit.convert(remaining, TimeUnit.MILLISECONDS);
            if (value <= 0L && (millis > 1000L || unit != TimeUnit.SECONDS)) continue;
            if (!str.isEmpty()) {
                str.append(delimiter);
            }
            str.append(label.formatted(String.valueOf(value)));
            remaining -= unit.toMillis(value);
        }
        return str.toString().trim();
    }

    static {
        LITERAL_TIME_UNITS.put(TimeUnit.DAYS, CoreLang.TIME_LABEL_DAY);
        LITERAL_TIME_UNITS.put(TimeUnit.HOURS, CoreLang.TIME_LABEL_HOUR);
        LITERAL_TIME_UNITS.put(TimeUnit.MINUTES, CoreLang.TIME_LABEL_MINUTE);
        LITERAL_TIME_UNITS.put(TimeUnit.SECONDS, CoreLang.TIME_LABEL_SECOND);
    }
}

