/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.manager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.util.bukkit.NightTask;
import su.nightexpress.nightcore.util.wrapper.UniTask;

public abstract class AbstractManager<P extends NightCorePlugin>
extends SimpleManager<P> {
    protected final Set<SimpeListener> listeners = new HashSet<SimpeListener>();
    protected final Set<Menu> menus = new HashSet<Menu>();
    @Deprecated
    protected final List<UniTask> tasks = new ArrayList<UniTask>();
    protected final List<NightTask> taskList = new ArrayList<NightTask>();

    public AbstractManager(@NotNull P plugin) {
        super(plugin);
    }

    @Override
    public void shutdown() {
        this.tasks.forEach(UniTask::stop);
        this.tasks.clear();
        this.taskList.forEach(NightTask::stop);
        this.taskList.clear();
        this.menus.forEach(Menu::clear);
        this.menus.clear();
        this.listeners.forEach(SimpeListener::unregisterListeners);
        this.listeners.clear();
        super.shutdown();
    }

    protected void addListener(@NotNull SimpeListener listener) {
        if (this.listeners.add(listener)) {
            listener.registerListeners();
        }
    }

    @Deprecated
    @NotNull
    protected <T extends Menu> T addMenu(@NotNull T menu) {
        this.menus.add(menu);
        return menu;
    }

    @NotNull
    protected <T extends Menu & ConfigBased> T addMenu(@NotNull T menu, @NotNull String path, @NotNull String file) {
        this.menus.add(menu);
        ((ConfigBased)menu).load(FileConfig.loadOrExtract(this.plugin, path, file));
        return menu;
    }

    protected void addTask(@NotNull Runnable runnable, int interval) {
        this.addTask(NightTask.create(this.plugin, runnable, interval));
    }

    protected void addTask(@NotNull Runnable runnable, long interval) {
        this.addTask(NightTask.create(this.plugin, runnable, interval));
    }

    protected void addAsyncTask(@NotNull Runnable runnable, int interval) {
        this.addTask(NightTask.createAsync(this.plugin, runnable, interval));
    }

    protected void addAsyncTask(@NotNull Runnable runnable, long interval) {
        this.addTask(NightTask.createAsync(this.plugin, runnable, interval));
    }

    @Deprecated
    protected void addTask(@NotNull UniTask task) {
        this.tasks.add(task);
        task.start();
    }

    protected void addTask(@NotNull NightTask task) {
        if (task.isValid()) {
            this.taskList.add(task);
        }
    }
}

