/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.db.AbstractUserDataManager;
import su.nightexpress.nightcore.db.config.UserdataConfig;
import su.nightexpress.nightcore.db.listener.UserListener;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.Players;

public abstract class AbstractUserManager<P extends NightPlugin, U extends AbstractUser>
extends AbstractManager<P> {
    private final UserdataConfig config;
    private final AbstractUserDataManager<P, U> dataManager;
    private final Map<UUID, U> loadedByIdMap;
    private final Map<String, U> loadedByNameMap;

    public AbstractUserManager(@NotNull P plugin, @NotNull AbstractUserDataManager<P, U> dataManager) {
        super(plugin);
        this.config = UserdataConfig.read(plugin);
        this.dataManager = dataManager;
        this.loadedByIdMap = new ConcurrentHashMap<UUID, U>();
        this.loadedByNameMap = new ConcurrentHashMap<String, U>();
    }

    @Override
    protected void onLoad() {
        this.addListener(new UserListener((NightPlugin)this.plugin, this));
        this.addAsyncTask(this::saveScheduled, this.config.getSaveInterval());
        this.addAsyncTask(this::unloadExpired, this.config.getCacheCleanupInterval());
        ((NightPlugin)this.plugin).onPostLoad(this::loadOnline);
    }

    @Override
    protected void onShutdown() {
        this.saveLoaded();
        this.loadedByIdMap.clear();
        this.loadedByNameMap.clear();
    }

    protected void onLoad(@NotNull U user) {
    }

    protected void onUnload(@NotNull U user) {
    }

    public void loadOnline() {
        Players.getOnline().forEach(player -> {
            U user = this.getOrFetch(player.getUniqueId());
            if (user != null) {
                this.cachePermanent(user);
            }
        });
    }

    public void unloadExpired() {
        this.getLoaded().forEach(user -> {
            if (user.isCacheExpired() && !user.isOnline()) {
                this.unload(user);
            }
        });
    }

    public final void handleJoin(@NotNull Player player) {
        U user = this.getLoaded(player);
        if (user == null) {
            return;
        }
        ((AbstractUser)user).setName(player.getName());
        this.cachePermanent(user);
    }

    public final void handleQuit(@NotNull Player player) {
        U user = this.getLoaded(player.getUniqueId());
        if (user == null) {
            return;
        }
        ((AbstractUser)user).setName(player.getName());
        ((AbstractUser)user).setLastOnline(System.currentTimeMillis());
        ((NightPlugin)this.plugin).runTaskAsync(task -> this.saveScheduled(Collections.singletonList(user)));
        this.cacheTemporary(user);
    }

    public void saveScheduled() {
        Set users = this.getLoaded().stream().filter(AbstractUser::isAutoSaveReady).collect(Collectors.toCollection(HashSet::new));
        this.saveScheduled(users);
    }

    private void saveScheduled(@NotNull Collection<U> users) {
        if (users.isEmpty()) {
            return;
        }
        this.dataManager.saveUsers(users);
        users.forEach(user -> {
            user.disableAutoSave();
            user.setAutoSyncIn(this.config.getSaveSyncPause());
        });
    }

    public void saveLoaded() {
        this.dataManager.saveUsers(this.getLoaded());
    }

    public void save(@NotNull Player player) {
        U user = this.getLoaded(player.getUniqueId());
        if (user == null) {
            return;
        }
        this.save(user);
    }

    public void save(@NotNull U user) {
        ((AbstractUser)user).setAutoSaveIn(this.config.getSaveDelay());
        ((AbstractUser)user).disableAutoSync();
    }

    private void load(@NotNull U user) {
        ((AbstractUser)user).onLoad();
        this.cacheTemporary(user);
        this.onLoad(user);
    }

    private void unload(@NotNull U user) {
        ((AbstractUser)user).onUnload();
        this.onUnload(user);
        this.loadedByIdMap.remove(((AbstractUser)user).getId());
        this.loadedByNameMap.remove(((AbstractUser)user).getName().toLowerCase());
    }

    @NotNull
    public abstract U create(@NotNull UUID var1, @NotNull String var2);

    public void cacheTemporary(@NotNull U user) {
        ((AbstractUser)user).setCacheFor(this.config.getCacheLifetime());
        this.cache(user);
    }

    public void cachePermanent(@NotNull U user) {
        ((AbstractUser)user).setPermanentCache();
        this.cache(user);
    }

    private void cache(@NotNull U user) {
        this.loadedByIdMap.putIfAbsent(((AbstractUser)user).getId(), user);
        this.loadedByNameMap.putIfAbsent(((AbstractUser)user).getName().toLowerCase(), user);
    }

    public boolean isInDatabase(@NotNull String name) {
        return this.dataManager.isUserExists(name);
    }

    public boolean isInDatabase(@NotNull UUID uuid) {
        return this.dataManager.isUserExists(uuid);
    }

    public void addInDatabase(@NotNull U user) {
        this.dataManager.insertUser(user);
    }

    public void saveInDatabase(@NotNull U user) {
        this.dataManager.saveUser(user);
    }

    @Nullable
    public U getFromDatabase(@NotNull String name) {
        return this.dataManager.getUser(name);
    }

    @Nullable
    public U getFromDatabase(@NotNull UUID uuid) {
        return this.dataManager.getUser(uuid);
    }

    @NotNull
    public final U getOrFetch(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        U user = this.getLoaded(uuid);
        if (user != null) {
            return user;
        }
        if (Players.isReal(player) && (user = this.getOrFetch(uuid)) != null) {
            ((NightPlugin)this.plugin).warn("Main thread user data load for '" + String.valueOf(uuid) + "' aka '" + player.getName() + "'.");
            return user;
        }
        return this.create(uuid, player.getName());
    }

    @Nullable
    public final U getOrFetch(@NotNull String name) {
        U user = this.getLoaded(name);
        if (user != null) {
            return user;
        }
        user = this.getFromDatabase(name);
        if (user != null) {
            this.load(user);
        }
        return user;
    }

    @Nullable
    public final U getOrFetch(@NotNull UUID uuid) {
        U user = this.getLoaded(uuid);
        if (user != null) {
            return user;
        }
        user = this.getFromDatabase(uuid);
        if (user != null) {
            this.load(user);
        }
        return user;
    }

    public final CompletableFuture<U> getUserDataAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> this.getOrFetch(name));
    }

    public final CompletableFuture<U> getUserDataAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.getOrFetch(uuid));
    }

    public void manageUser(@NotNull String name, Consumer<U> consumer) {
        this.manageUser(() -> this.getLoaded(name), () -> this.getUserDataAsync(name), consumer);
    }

    public void manageUser(@NotNull UUID playerId, Consumer<U> consumer) {
        this.manageUser(() -> this.getLoaded(playerId), () -> this.getUserDataAsync(playerId), consumer);
    }

    public void manageUserSynchronized(@NotNull String name, Consumer<U> consumer) {
        this.manageUserSynchronized(() -> this.getLoaded(name), () -> this.getUserDataAsync(name), consumer);
    }

    public void manageUserSynchronized(@NotNull UUID playerId, Consumer<U> consumer) {
        this.manageUserSynchronized(() -> this.getLoaded(playerId), () -> this.getUserDataAsync(playerId), consumer);
    }

    private void manageUserSynchronized(@NotNull Supplier<U> loadedSupplier, @NotNull Supplier<CompletableFuture<U>> fetchSupplier, @NotNull Consumer<U> consumer) {
        this.manageUser(loadedSupplier, fetchSupplier, user -> ((NightPlugin)this.plugin).runTask(task -> consumer.accept(user)));
    }

    public void manageUser(@NotNull Player player, Consumer<U> consumer) {
        this.manageUser(player, consumer, false);
    }

    public void manageUserWithSave(@NotNull Player player, Consumer<U> consumer) {
        this.manageUser(player, consumer, true);
    }

    private void manageUser(@NotNull Player player, Consumer<U> consumer, boolean save) {
        U user = this.getLoaded(player);
        if (user == null) {
            return;
        }
        consumer.accept(user);
        if (save) {
            this.save(user);
        }
    }

    private void manageUser(@NotNull Supplier<U> loadedSupplier, @NotNull Supplier<CompletableFuture<U>> fetchSupplier, @NotNull Consumer<U> consumer) {
        AbstractUser user = (AbstractUser)loadedSupplier.get();
        if (user != null) {
            consumer.accept(user);
        } else {
            fetchSupplier.get().thenAccept((Consumer)consumer);
        }
    }

    @NotNull
    public Set<U> getAll() {
        Set<U> users = this.getLoaded();
        this.dataManager.getUsers().stream().filter(user -> !this.isLoaded(user.getId())).forEach(users::add);
        return users;
    }

    @NotNull
    public Set<U> getLoaded() {
        return new HashSet<U>(this.loadedByIdMap.values());
    }

    @NotNull
    public Map<UUID, U> getLoadedByIdMap() {
        return this.loadedByIdMap;
    }

    @NotNull
    public Map<String, U> getLoadedByNameMap() {
        return this.loadedByNameMap;
    }

    @Nullable
    public U getLoaded(@NotNull Player player) {
        return this.getLoaded(player.getUniqueId());
    }

    @Nullable
    public U getLoaded(@NotNull UUID uuid) {
        return (U)((AbstractUser)this.loadedByIdMap.get(uuid));
    }

    @Nullable
    public U getLoaded(@NotNull String name) {
        AbstractUser byName = (AbstractUser)this.loadedByNameMap.get(name.toLowerCase());
        if (byName != null) {
            return (U)byName;
        }
        Player player = Players.getPlayer(name);
        return player == null ? null : (U)this.getLoaded(player.getUniqueId());
    }

    public boolean isLoaded(@NotNull Player player) {
        return this.isLoaded(player.getUniqueId());
    }

    public boolean isLoaded(@NotNull UUID id) {
        return this.loadedByIdMap.containsKey(id);
    }

    public boolean isLoaded(@NotNull String name) {
        return this.getLoaded(name) != null;
    }
}

