/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.paper.text;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.bridge.paper.PaperBridge;
import su.nightexpress.nightcore.bridge.paper.text.PaperObjectContantsAdapter;
import su.nightexpress.nightcore.bridge.text.NightStyle;
import su.nightexpress.nightcore.bridge.text.NightTextDecoration;
import su.nightexpress.nightcore.bridge.text.adapter.TextComponentAdapter;
import su.nightexpress.nightcore.bridge.text.event.NightClickEvent;
import su.nightexpress.nightcore.bridge.text.event.NightHoverEvent;
import su.nightexpress.nightcore.bridge.text.event.WrappedPayload;
import su.nightexpress.nightcore.bridge.text.impl.NightKeybindComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightObjectComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTextComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTranslatableComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTranslationArgument;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class PaperTextComponentAdapter
implements TextComponentAdapter<Component> {
    private final PaperBridge bridge;

    public PaperTextComponentAdapter(@NotNull PaperBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void send(@NotNull CommandSender sender, @NotNull NightComponent component) {
        sender.sendMessage(this.adaptComponent(component));
    }

    @Override
    public void sendActionBar(@NotNull Player player, @NotNull NightComponent component) {
        player.sendActionBar(this.adaptComponent(component));
    }

    @Override
    @NotNull
    public String toJson(@NotNull NightComponent component) {
        return (String)JSONComponentSerializer.json().serialize(this.adaptComponent(component));
    }

    @Override
    @NotNull
    public String toLegacy(@NotNull NightComponent component) {
        return LegacyComponentSerializer.legacy((char)'\u00a7').serialize(this.adaptComponent(component));
    }

    @NotNull
    public ClickEvent adaptClickEvent(@NotNull NightClickEvent nightClickEvent) {
        WrappedPayload payload = nightClickEvent.payload();
        return switch (nightClickEvent.action()) {
            default -> throw new MatchException(null, null);
            case NightClickEvent.Action.CUSTOM -> {
                WrappedPayload.Custom custom = (WrappedPayload.Custom)payload;
                NightKey namespacedKey = custom.key();
                Key key = Key.key((String)namespacedKey.namespace(), (String)namespacedKey.value());
                BinaryTagHolder nbt = BinaryTagHolder.binaryTagHolder((String)custom.nbt().asString());
                yield ClickEvent.custom((Key)key, (BinaryTagHolder)nbt);
            }
            case NightClickEvent.Action.OPEN_URL -> ClickEvent.openUrl((String)((WrappedPayload.Text)payload).value());
            case NightClickEvent.Action.OPEN_FILE -> ClickEvent.openFile((String)((WrappedPayload.Text)payload).value());
            case NightClickEvent.Action.CHANGE_PAGE -> ClickEvent.changePage((int)((WrappedPayload.Int)payload).integer());
            case NightClickEvent.Action.RUN_COMMAND -> ClickEvent.runCommand((String)((WrappedPayload.Text)payload).value());
            case NightClickEvent.Action.SHOW_DIALOG -> ClickEvent.showDialog((DialogLike)((DialogLike)this.bridge.getDialogAdapter().adaptDialog(((WrappedPayload.Dialog)payload).dialog())));
            case NightClickEvent.Action.SUGGEST_COMMAND -> ClickEvent.suggestCommand((String)((WrappedPayload.Text)payload).value());
            case NightClickEvent.Action.COPY_TO_CLIPBOARD -> ClickEvent.copyToClipboard((String)((WrappedPayload.Text)payload).value());
        };
    }

    @Nullable
    public <V> HoverEvent<?> adaptHoverEvent(@NotNull NightHoverEvent<V> event) {
        V value = event.value();
        if (value instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)value;
            return itemStack.asHoverEvent();
        }
        if (value instanceof NightComponent) {
            NightComponent component = (NightComponent)value;
            return HoverEvent.showText((Component)this.adaptComponent(component));
        }
        return null;
    }

    @NotNull
    public TextDecoration adaptTextDecoration(@NotNull NightTextDecoration nightDecoration) {
        return switch (nightDecoration) {
            default -> throw new MatchException(null, null);
            case NightTextDecoration.BOLD -> TextDecoration.BOLD;
            case NightTextDecoration.ITALIC -> TextDecoration.ITALIC;
            case NightTextDecoration.OBFUSCATED -> TextDecoration.OBFUSCATED;
            case NightTextDecoration.UNDERLINED -> TextDecoration.UNDERLINED;
            case NightTextDecoration.STRIKETHROUGH -> TextDecoration.STRIKETHROUGH;
        };
    }

    @NotNull
    public TextDecoration.State adaptTextDecorationState(@NotNull NightTextDecoration.State nightState) {
        return switch (nightState) {
            default -> throw new MatchException(null, null);
            case NightTextDecoration.State.TRUE -> TextDecoration.State.TRUE;
            case NightTextDecoration.State.FALSE -> TextDecoration.State.FALSE;
            case NightTextDecoration.State.NOT_SET -> TextDecoration.State.NOT_SET;
        };
    }

    @NotNull
    public Style adaptStyle(@NotNull NightStyle nightStyle) {
        NightKey font = nightStyle.font();
        Color color = nightStyle.color();
        Color shadowColor = nightStyle.shadowColor();
        Map<NightTextDecoration, NightTextDecoration.State> decorations = nightStyle.decorations();
        NightClickEvent clickEvent = nightStyle.clickEvent();
        NightHoverEvent<?> hoverEvent = nightStyle.hoverEvent();
        String insertion = nightStyle.insertion();
        return Style.style(builder -> {
            decorations.forEach((nightDecoration, nightState) -> builder.decoration(this.adaptTextDecoration((NightTextDecoration)((Object)((Object)nightDecoration))), this.adaptTextDecorationState((NightTextDecoration.State)((Object)((Object)nightState)))));
            if (Version.isAtLeast(Version.MC_1_21_6)) {
                Compat.setShadowColor(builder, shadowColor);
            }
            builder.font(font == null ? null : Key.key((String)font.namespace(), (String)font.value())).color(color == null ? null : TextColor.color((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue())).clickEvent(clickEvent == null ? null : this.adaptClickEvent(clickEvent)).hoverEvent(hoverEvent == null ? null : this.adaptHoverEvent(hoverEvent)).insertion(insertion);
        });
    }

    @NotNull
    public List<Component> adaptComponents(@NotNull List<NightComponent> components) {
        return Lists.modify(components, this::adaptComponent);
    }

    @Override
    @NotNull
    public Component adaptComponent(@NotNull NightComponent nightComponent) {
        return nightComponent.adapt(this);
    }

    @Override
    @NotNull
    public TextComponent adaptComponent(@NotNull NightTextComponent component) {
        String content = component.content();
        if (content.equals("\n")) {
            return Component.newline();
        }
        return Component.text(builder -> ((TextComponent.Builder)((TextComponent.Builder)builder.style(this.adaptStyle(component.style()))).append(this.adaptComponents(component.children()))).content(content));
    }

    @NotNull
    public TranslationArgument adaptTranslatableArgument(@NotNull NightTranslationArgument nightArgument) {
        return TranslationArgument.component((ComponentLike)this.adaptComponent(nightArgument.asComponent()));
    }

    @Override
    @NotNull
    public TranslatableComponent adaptComponent(@NotNull NightTranslatableComponent component) {
        String fallback = component.fallback();
        List<NightTranslationArgument> nightArguments = component.arguments();
        List<TranslationArgument> arguments = Lists.modify(nightArguments, this::adaptTranslatableArgument);
        return Component.translatable(builder -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)builder.style(this.adaptStyle(component.style()))).append(this.adaptComponents(component.children()))).key(component.key()).fallback(fallback).arguments(arguments));
    }

    @Override
    @NotNull
    public Component adaptComponent(@NotNull NightKeybindComponent component) {
        return Component.keybind(builder -> ((KeybindComponent.Builder)((KeybindComponent.Builder)builder.style(this.adaptStyle(component.style()))).append(this.adaptComponents(component.children()))).keybind(component.key()));
    }

    @Override
    @NotNull
    public Component adaptComponent(@NotNull NightObjectComponent component) {
        return Component.object((ObjectContents)PaperObjectContantsAdapter.get().adaptContents(component.contents()));
    }

    static class Compat {
        Compat() {
        }

        static void setShadowColor(@NotNull Style.Builder builder, @Nullable Color shadowColor) {
            builder.shadowColor(shadowColor == null ? null : ShadowColor.shadowColor((int)shadowColor.getRed(), (int)shadowColor.getGreen(), (int)shadowColor.getBlue(), (int)shadowColor.getAlpha()));
        }
    }
}

