/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.dialog.wrap.base;

import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogBaseAdapter;
import su.nightexpress.nightcore.bridge.dialog.wrap.base.WrappedDialogAfterAction;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.util.Lists;

public record WrappedDialogBase(@NotNull String title, @Nullable String externalTitle, boolean canCloseWithEscape, boolean pause, @NotNull WrappedDialogAfterAction afterAction, @NotNull List<WrappedDialogBody> body, @NotNull List<WrappedDialogInput> inputs) {
    @NotNull
    public <B> B adapt(@NotNull DialogBaseAdapter<B> adapter) {
        return adapter.adaptBase(this);
    }

    @Deprecated
    @NotNull
    public WrappedDialogBase replace(@NotNull UnaryOperator<String> operator) {
        String title = (String)operator.apply(this.title);
        String externalTitle = this.externalTitle == null ? null : (String)operator.apply(this.externalTitle);
        List<WrappedDialogBody> bodyReplaced = this.body.stream().map(other -> other.replace(operator)).toList();
        List<WrappedDialogInput> inputsReplaced = this.inputs.stream().map(other -> other.replace(operator)).toList();
        return new WrappedDialogBase(title, externalTitle, this.canCloseWithEscape, this.pause, this.afterAction, bodyReplaced, inputsReplaced);
    }

    public static final class Builder {
        private final String title;
        private String externalTitle;
        private boolean canCloseWithEscape = true;
        private boolean pause = false;
        private WrappedDialogAfterAction afterAction = WrappedDialogAfterAction.CLOSE;
        private List<WrappedDialogBody> body = Collections.emptyList();
        private List<WrappedDialogInput> inputs = Collections.emptyList();

        public Builder(@NotNull String title) {
            this.title = title;
        }

        @NotNull
        public Builder externalTitle(@Nullable String externalTitle) {
            this.externalTitle = externalTitle;
            return this;
        }

        @NotNull
        public Builder canCloseWithEscape(boolean canCloseWithEscape) {
            this.canCloseWithEscape = canCloseWithEscape;
            return this;
        }

        @NotNull
        public Builder pause(boolean pause) {
            this.pause = pause;
            return this;
        }

        @NotNull
        public Builder afterAction(@NotNull WrappedDialogAfterAction afterAction) {
            this.afterAction = afterAction;
            return this;
        }

        @NotNull
        public Builder body(WrappedDialogBody ... body) {
            return this.body(Lists.newList(body));
        }

        @NotNull
        public Builder body(@NotNull List<WrappedDialogBody> body) {
            this.body = List.copyOf(body);
            return this;
        }

        @NotNull
        public Builder inputs(WrappedDialogInput ... inputs) {
            return this.inputs(Lists.newList(inputs));
        }

        @NotNull
        public Builder inputs(@NotNull List<WrappedDialogInput> inputs) {
            this.inputs = List.copyOf(inputs);
            return this;
        }

        @NotNull
        public WrappedDialogBase build() {
            return new WrappedDialogBase(this.title, this.externalTitle, this.canCloseWithEscape, this.pause, this.afterAction, this.body, this.inputs);
        }
    }
}

