/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.ui.dialog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.dialog.response.DialogClickResult;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class Dialogs {
    private static final Map<UUID, WrappedDialog> ACTIVE_DIALOGS = new HashMap<UUID, WrappedDialog>();

    public static void clearDialogs() {
        new HashSet<UUID>(ACTIVE_DIALOGS.keySet()).stream().map(Players::getPlayer).filter(Objects::nonNull).forEach(Dialogs::exitDialog);
        ACTIVE_DIALOGS.clear();
    }

    public static boolean isInDialog(@NotNull Player player) {
        return ACTIVE_DIALOGS.containsKey(player.getUniqueId());
    }

    @Nullable
    public static WrappedDialog getDialog(@NotNull Player player) {
        return ACTIVE_DIALOGS.get(player.getUniqueId());
    }

    public static void handleClick(@NotNull Player player, @NotNull DialogClickResult result) {
        WrappedDialog dialog = ACTIVE_DIALOGS.remove(player.getUniqueId());
        if (dialog == null) {
            return;
        }
        dialog.handleResponse(result);
    }

    public static void exitDialog(@NotNull Player player) {
        WrappedDialog dialog = ACTIVE_DIALOGS.remove(player.getUniqueId());
        if (dialog == null) {
            return;
        }
        Players.closeDialog(player);
    }

    public static void showDialog(@NotNull Player player, @NotNull WrappedDialog dialog) {
        Dialogs.showDialog(player, dialog, null);
    }

    public static void showDialog(@NotNull Player player, @NotNull WrappedDialog dialog, @Nullable Consumer<Replacer> replacer) {
        if (replacer != null) {
            dialog = dialog.replace(Replacer.create().and(replacer).chained());
        }
        ACTIVE_DIALOGS.put(player.getUniqueId(), dialog);
        Software.instance().showDialog(player, dialog);
    }

    @NotNull
    public static WrappedDialog create(@NotNull Consumer<WrappedDialog.Builder> consumer) {
        WrappedDialog.Builder builder = Dialogs.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static void createAndShow(@NotNull Player player, @NotNull Consumer<WrappedDialog.Builder> consumer) {
        Dialogs.createAndShow(player, consumer, null);
    }

    public static void createAndShow(@NotNull Player player, @NotNull Consumer<WrappedDialog.Builder> consumer, @Nullable Consumer<Replacer> replacer) {
        WrappedDialog dialog = Dialogs.create(consumer);
        Dialogs.showDialog(player, dialog, replacer);
    }

    @NotNull
    public static WrappedDialog.Builder builder() {
        return new WrappedDialog.Builder();
    }
}

