/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale;

import org.bukkit.Keyed;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangElement;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.locale.entry.BooleanLocale;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.RegistryLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.locale.message.MessageData;
import su.nightexpress.nightcore.util.bridge.RegistryType;

public class LangEntry<T extends LangValue>
implements LangElement {
    protected final ConfigValue.Loader<T> loader;
    protected final String path;
    protected final T defaultValue;
    protected T value;

    public LangEntry(@NotNull ConfigValue.Loader<T> loader, @NotNull String path, @NotNull T defaultValue) {
        this.loader = loader;
        this.path = path;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void load(@NotNull NightPlugin plugin, @NotNull FileConfig config) {
        this.value = (LangValue)ConfigValue.create(this.path, this.loader, this.getDefaultValue(), new String[0]).read(config);
    }

    @NotNull
    public static Builder builder(@NotNull String path) {
        return new Builder(path);
    }

    @NotNull
    public static IconLocale.Builder iconBuilder(@NotNull String path) {
        return new IconLocale.Builder(path);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public T value() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public static class Builder {
        private final String path;

        public Builder(@NotNull String path) {
            this.path = path;
        }

        @NotNull
        public MessageLocale message(@NotNull MessageData data, String ... text) {
            return MessageLocale.message(this.path, data, text);
        }

        @NotNull
        public MessageLocale chatMessage(@NotNull String text) {
            return this.chatMessage(new String[]{text});
        }

        @NotNull
        public MessageLocale chatMessage(String ... text) {
            return MessageLocale.chat(this.path, text);
        }

        @NotNull
        public MessageLocale chatMessage(@NotNull Sound sound, String ... text) {
            return MessageLocale.chat(this.path, sound, text);
        }

        @NotNull
        public MessageLocale titleMessage(@NotNull String title, @NotNull String subtitle) {
            return MessageLocale.title(this.path, title, subtitle);
        }

        @NotNull
        public MessageLocale titleMessage(@NotNull String title, @NotNull String subtitle, @NotNull Sound sound) {
            return MessageLocale.title(this.path, title, subtitle, sound);
        }

        @NotNull
        public MessageLocale titleMessage(@NotNull String title, @NotNull String subtitle, int fade, int stay) {
            return MessageLocale.title(this.path, title, subtitle, fade, stay);
        }

        @NotNull
        public MessageLocale titleMessage(@NotNull String title, @NotNull String subtitle, int fade, int stay, @NotNull Sound sound) {
            return MessageLocale.title(this.path, title, subtitle, fade, stay, sound);
        }

        @NotNull
        public MessageLocale actionBarMessage(@NotNull String text) {
            return MessageLocale.actionBar(this.path, text);
        }

        @NotNull
        public MessageLocale actionBarMessage(@NotNull String text, @NotNull Sound sound) {
            return MessageLocale.actionBar(this.path, text, sound);
        }

        @NotNull
        public BooleanLocale bool(@NotNull String onTrue, @NotNull String onFalse) {
            return BooleanLocale.create(this.path, onTrue, onFalse);
        }

        @NotNull
        public TextLocale text(@NotNull String text) {
            return TextLocale.create(this.path, text);
        }

        @NotNull
        public TextLocale text(String ... text) {
            return TextLocale.create(this.path, text);
        }

        @NotNull
        public <E extends Enum<E>> EnumLocale<E> enumeration(@NotNull Class<E> clazz) {
            return EnumLocale.create(this.path, clazz);
        }

        @NotNull
        public <E extends Keyed> RegistryLocale<E> registry(@NotNull RegistryType<E> type) {
            return RegistryLocale.create(this.path, type);
        }

        @NotNull
        public ButtonLocale button(@NotNull String label) {
            return ButtonLocale.create(this.path, label);
        }

        @NotNull
        public ButtonLocale button(@NotNull String label, int width) {
            return ButtonLocale.create(this.path, label, width);
        }

        @NotNull
        public ButtonLocale button(@NotNull String label, @Nullable String tooltip) {
            return ButtonLocale.create(this.path, label, tooltip);
        }

        @NotNull
        public ButtonLocale button(@NotNull String label, @Nullable String tooltip, int width) {
            return ButtonLocale.create(this.path, label, tooltip, width);
        }

        @NotNull
        public DialogElementLocale dialogElement(String ... contents) {
            return DialogElementLocale.create(this.path, contents);
        }

        @NotNull
        public DialogElementLocale dialogElement(int width, String ... contents) {
            return DialogElementLocale.create(this.path, width, contents);
        }
    }
}

