/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands.tree;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.argument.ArgumentReader;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.CommandContextBuilder;
import su.nightexpress.nightcore.commands.context.Suggestions;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.commands.tree.LiteralNode;
import su.nightexpress.nightcore.core.config.CoreLang;

public class FlagNode
extends CommandNode {
    private static final String PREFIX = "-";

    public FlagNode(@NotNull String name) {
        super(name, null, Collections.emptyList());
    }

    @Override
    @NotNull
    public Collection<? extends CommandNode> getRelevantNodes(@NotNull ArgumentReader reader) {
        return this.getChildren();
    }

    @Override
    public void parse(@NotNull ArgumentReader reader, @NotNull CommandContextBuilder contextBuilder) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String string = reader.getCursorArgument();
        contextBuilder.withNode(this, cursor);
        if (!string.startsWith(PREFIX)) {
            return;
        }
        if (string.length() < 2) {
            return;
        }
        String flagName = string.substring(1);
        ExecutableNode executable = contextBuilder.getExecutor();
        if (!(executable instanceof LiteralNode)) {
            return;
        }
        LiteralNode parent = (LiteralNode)executable;
        FlagNode realFlag = parent.getFlag(flagName);
        if (realFlag == null) {
            return;
        }
        contextBuilder.withFlag(realFlag.getName());
    }

    @Override
    protected void provideSuggestions(@NotNull ArgumentReader reader, @NotNull CommandContext context, @NotNull Suggestions suggestions) {
        ExecutableNode executable = context.getExecutor();
        if (!(executable instanceof LiteralNode)) {
            return;
        }
        LiteralNode parent = (LiteralNode)executable;
        suggestions.setSuggestions(parent.getFlags().stream().filter(flagNode -> !context.hasFlag(flagNode.getName())).map(FlagNode::getPrefixed).toList());
    }

    @Override
    @NotNull
    public String getUsage() {
        return CoreLang.COMMAND_USAGE_OPTIONAL_FLAG.text().replace("%name%", this.getPrefixed());
    }

    @NotNull
    public String getPrefixed() {
        return PREFIX + this.name;
    }
}

