/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.Registries;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;
import su.nightexpress.nightcore.integration.currency.impl.DummyCurrency;

public class EconomyBridge {
    public static void unregisterAll() {
        EconomyBridge.registry().clear();
    }

    @NotNull
    public static NightRegistry<Currency> registry() {
        return Registries.CURRENCY;
    }

    public static boolean hasCurrency(@NotNull String id) {
        return EconomyBridge.getCurrency(id) != null;
    }

    public static boolean hasEconomy() {
        return EconomyBridge.hasCurrency("vault");
    }

    public static boolean handle(@NotNull String id, @NotNull Consumer<Currency> consumer) {
        Currency currency = EconomyBridge.getCurrency(id);
        if (currency == null) {
            return false;
        }
        consumer.accept(currency);
        return true;
    }

    public static boolean hasEnough(@NotNull Player player, @NotNull String id, double amount) {
        return EconomyBridge.getBalance(player, id) >= amount;
    }

    public static boolean hasEnough(@NotNull UUID playerId, @NotNull String id, double amount) {
        return EconomyBridge.getBalance(playerId, id) >= amount;
    }

    public static double getBalance(@NotNull Player player, @NotNull String id) {
        Currency currency = EconomyBridge.getCurrency(id);
        return currency == null ? 0.0 : currency.getBalance(player);
    }

    public static double getBalance(@NotNull UUID playerId, @NotNull String id) {
        Currency currency = EconomyBridge.getCurrency(id);
        return currency == null ? 0.0 : currency.getBalance(playerId);
    }

    public static double getEconomyBalance(@NotNull Player player) {
        return EconomyBridge.getEconomyBalance(player.getUniqueId());
    }

    public static double getEconomyBalance(@NotNull UUID playerId) {
        return EconomyBridge.getBalance(playerId, "vault");
    }

    public static boolean deposit(@NotNull Player player, @NotNull String id, double amount) {
        return EconomyBridge.handle(id, currency -> currency.give(player, amount));
    }

    public static boolean deposit(@NotNull UUID playerId, @NotNull String id, double amount) {
        return EconomyBridge.handle(id, currency -> currency.give(playerId, amount));
    }

    public static boolean depositEconomy(@NotNull Player player, double amount) {
        return EconomyBridge.depositEconomy(player.getUniqueId(), amount);
    }

    public static boolean depositEconomy(@NotNull UUID playerId, double amount) {
        return EconomyBridge.deposit(playerId, "vault", amount);
    }

    public static boolean withdraw(@NotNull Player player, @NotNull String id, double amount) {
        return EconomyBridge.handle(id, currency -> currency.take(player, amount));
    }

    public static boolean withdraw(@NotNull UUID playerId, @NotNull String id, double amount) {
        return EconomyBridge.handle(id, currency -> currency.take(playerId, amount));
    }

    public static boolean withdrawEconomy(@NotNull Player player, double amount) {
        return EconomyBridge.withdrawEconomy(player.getUniqueId(), amount);
    }

    public static boolean withdrawEconomy(@NotNull UUID playerId, double amount) {
        return EconomyBridge.withdraw(playerId, "vault", amount);
    }

    public static boolean hasCurrency() {
        return !EconomyBridge.registry().isEmpty();
    }

    public static void register(@NotNull Currency currency) {
        EconomyBridge.registry().add(currency.getInternalId(), currency);
    }

    @NotNull
    public static Set<Currency> getCurrencies() {
        return EconomyBridge.registry().values();
    }

    @NotNull
    public static Set<String> getCurrencyIds() {
        return EconomyBridge.registry().keys();
    }

    @NotNull
    public static Optional<Currency> currency(@NotNull String internalId) {
        return Optional.ofNullable(EconomyBridge.getCurrency(internalId));
    }

    @Nullable
    public static Currency getCurrency(@NotNull String internalId) {
        return EconomyBridge.registry().byKey(internalId);
    }

    @NotNull
    public static Currency getCurrencyOrDummy(@NotNull String internalId) {
        return EconomyBridge.registry().lookup(internalId).orElse(DummyCurrency.INSTANCE);
    }

    @Nullable
    public static Currency getEconomyCurrency() {
        return EconomyBridge.getCurrency("vault");
    }

    @NotNull
    public static Optional<Currency> economyCurrency() {
        return Optional.ofNullable(EconomyBridge.getEconomyCurrency());
    }

    @NotNull
    public static DummyCurrency getDummyCurrency() {
        return DummyCurrency.INSTANCE;
    }
}

