/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.bridge;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.bossbar.NightBarColor;
import su.nightexpress.nightcore.bridge.bossbar.NightBarFlag;
import su.nightexpress.nightcore.bridge.bossbar.NightBarOverlay;
import su.nightexpress.nightcore.bridge.bossbar.NightBossBar;
import su.nightexpress.nightcore.bridge.dialog.response.DialogClickHandler;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.text.adapter.TextComponentAdapter;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public interface Software {
    public static final Holder INSTANCE = new Holder();

    @NotNull
    public static Software instance() {
        return INSTANCE.get();
    }

    public boolean initialize();

    @NotNull
    public String getName();

    public boolean isPaper();

    public int nextEntityId();

    @NotNull
    public Listener createDialogListener(@NotNull DialogClickHandler var1);

    public void closeDialog(@NotNull Player var1);

    public void showDialog(@NotNull Player var1, @NotNull WrappedDialog var2);

    @NotNull
    public TextComponentAdapter<?> getTextComponentAdapter();

    @NotNull
    public SimpleCommandMap getCommandMap();

    @NotNull
    public Map<String, Command> getKnownCommands(@NotNull SimpleCommandMap var1);

    @NotNull
    public InventoryView createView(@NotNull MenuType var1, @NotNull NightComponent var2, @NotNull Player var3);

    @NotNull
    public NightProfile createProfile(@NotNull UUID var1);

    @NotNull
    public NightProfile createProfile(@NotNull String var1);

    @NotNull
    public NightProfile createProfile(@Nullable UUID var1, @Nullable String var2);

    @NotNull
    public NightProfile getProfile(@NotNull OfflinePlayer var1);

    public void sendTitles(@NotNull Player var1, @NotNull NightComponent var2, @NotNull NightComponent var3, int var4, int var5, int var6);

    @NotNull
    public Set<String> getCommonComponentsToHide();

    @NotNull
    public Set<String> getHiddenComponents(@NotNull ItemStack var1);

    @NotNull
    public String getTranslationKey(@NotNull Material var1);

    @NotNull
    public String getTranslationKey(@NotNull Attribute var1);

    @NotNull
    public String getTranslationKey(@NotNull Enchantment var1);

    @NotNull
    public String getTranslationKey(@NotNull EntityType var1);

    @NotNull
    public String getTranslationKey(@NotNull PotionEffectType var1);

    public void setCustomName(@NotNull Entity var1, @NotNull NightComponent var2);

    @Nullable
    public String getEntityName(@NotNull Entity var1);

    @NotNull
    public ItemStack setType(@NotNull ItemStack var1, @NotNull Material var2);

    public void editMeta(@NotNull ItemStack var1, @NotNull Consumer<ItemMeta> var2);

    public <T extends ItemMeta> void editMeta(@NotNull ItemStack var1, @NotNull Class<T> var2, @NotNull Consumer<T> var3);

    @Nullable
    public String getCustomName(@NotNull ItemMeta var1);

    public void setCustomName(@NotNull ItemMeta var1, @Nullable NightComponent var2);

    @Nullable
    public String getItemName(@NotNull ItemMeta var1);

    public void setItemName(@NotNull ItemMeta var1, @NotNull NightComponent var2);

    @Nullable
    public List<String> getLore(@NotNull ItemMeta var1);

    public void setLore(@NotNull ItemMeta var1, @Nullable List<NightComponent> var2);

    @Nullable
    public NightProfile getOwnerProfile(@NotNull ItemStack var1);

    public void hideComponents(@NotNull ItemStack var1);

    public void hideComponents(@NotNull ItemStack var1, @NotNull Set<String> var2);

    @NotNull
    public NightBossBar createBossBar(@NotNull NightComponent var1, @NotNull NightBarColor var2, @NotNull NightBarOverlay var3, NightBarFlag ... var4);

    public static final class Holder {
        private Software software;

        public void load(@NotNull Software software) {
            if (this.software != null) {
                throw new IllegalStateException("Software is already initialized!");
            }
            this.software = software;
            this.software.initialize();
        }

        @NotNull
        public Software get() {
            if (this.software == null) {
                throw new IllegalStateException("Software is not yet initialized!");
            }
            return this.software;
        }
    }
}

