/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.integration.currency.impl;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.nightcore.integration.currency.CurrencyId;
import su.nightexpress.nightcore.integration.currency.type.AbstractCurrency;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class CoinsEngineCurrency
extends AbstractCurrency {
    public CoinsEngineCurrency(@NotNull String id) {
        super(id, CurrencyId.forCoinsEngine(id));
    }

    @NotNull
    public static Set<CoinsEngineCurrency> getCurrencies() {
        HashSet<CoinsEngineCurrency> currencies = new HashSet<CoinsEngineCurrency>();
        CoinsEngineAPI.getCurrencyManager().getCurrencies().forEach(currency -> {
            if (!currency.isVaultEconomy()) {
                currencies.add(new CoinsEngineCurrency(currency.getId()));
            }
        });
        return currencies;
    }

    @NotNull
    private Optional<Currency> currency() {
        return Optional.ofNullable(CoinsEngineAPI.getCurrency((String)this.originalId));
    }

    @Override
    public boolean canHandleDecimals() {
        return this.currency().map(Currency::isDecimal).orElse(true);
    }

    @Override
    public boolean canHandleOffline() {
        return true;
    }

    @Override
    public double floorIfNeeded(double amount) {
        return this.currency().map(currency -> currency.floorIfNeeded(amount)).orElse(amount);
    }

    @Override
    @NotNull
    public String formatValue(double amount) {
        return this.currency().map(currency -> currency.formatValue(amount)).orElse(String.valueOf(amount));
    }

    @Override
    @NotNull
    public String getName() {
        return this.currency().map(Currency::getName).orElse(this.getOriginalId());
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.currency().map(Currency::getFormat).orElse("%amount%");
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return this.currency().map(Currency::icon).orElse(NightItem.fromType(Material.GOLD_NUGGET)).getItemStack();
    }

    @Override
    public double getBalance(@NotNull Player player) {
        return this.currency().map(currency -> CoinsEngineAPI.getBalance((Player)player, (Currency)currency)).orElse(0.0);
    }

    @Override
    public double getBalance(@NotNull UUID playerId) {
        return CoinsEngineAPI.getBalance((UUID)playerId, (String)this.originalId);
    }

    @Override
    public void give(@NotNull Player player, double amount) {
        this.currency().ifPresent(currency -> CoinsEngineAPI.addBalance((Player)player, (Currency)currency, (double)amount));
    }

    @Override
    public void give(@NotNull UUID playerId, double amount) {
        CoinsEngineAPI.addBalance((UUID)playerId, (String)this.originalId, (double)amount);
    }

    @Override
    public void take(@NotNull Player player, double amount) {
        this.currency().ifPresent(currency -> CoinsEngineAPI.removeBalance((Player)player, (Currency)currency, (double)amount));
    }

    @Override
    public void take(@NotNull UUID playerId, double amount) {
        CoinsEngineAPI.removeBalance((UUID)playerId, (String)this.originalId, (double)amount);
    }
}

