/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.tag;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.text.night.tag.TagHandler;
import su.nightexpress.nightcore.util.text.night.tag.handler.ColorTagHandler;
import su.nightexpress.nightcore.util.text.night.tag.handler.DecorationTagHandler;
import su.nightexpress.nightcore.util.text.night.tag.handler.GradientTagHandler;
import su.nightexpress.nightcore.util.text.night.tag.handler.NamedColorTagHandler;
import su.nightexpress.nightcore.util.text.night.tag.handler.ShadowTagHandler;

public interface TagPool
extends Predicate<TagHandler> {
    public static final TagPool ALL = tag -> true;
    public static final TagPool NONE = tag -> false;
    public static final TagPool BASE_COLORS = tag -> tag instanceof ColorTagHandler || tag instanceof NamedColorTagHandler;
    public static final TagPool ADVANCED_COLORS = tag -> tag instanceof GradientTagHandler || tag instanceof ShadowTagHandler;
    public static final TagPool DECORATIONS = tag -> tag instanceof DecorationTagHandler;
    public static final TagPool NO_INVERTED_DECORATIONS = tag -> {
        DecorationTagHandler handler;
        return !(tag instanceof DecorationTagHandler) || !(handler = (DecorationTagHandler)tag).isInverted();
    };
    public static final Predicate<TagHandler> ALL_COLORS = BASE_COLORS.and(ADVANCED_COLORS);
    public static final Predicate<TagHandler> BASE_COLORS_AND_DECORATIONS = BASE_COLORS.and(DECORATIONS);
    public static final Predicate<TagHandler> ALL_COLORS_AND_DECORATIONS = ALL_COLORS.and(DECORATIONS);

    default public boolean isGoodTag(@NotNull TagHandler handler) {
        return this.test(handler);
    }
}

