/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.Engine;
import su.nightexpress.nightcore.util.regex.MatcherTimeoutException;
import su.nightexpress.nightcore.util.regex.TimeoutCharSequence;

public class TimedMatcher {
    private final Matcher matcher;
    private boolean debug;

    public TimedMatcher(@NotNull Matcher matcher) {
        this.matcher = matcher;
    }

    @NotNull
    public static TimedMatcher create(@NotNull String pattern, @NotNull String str) {
        return TimedMatcher.create(pattern, str, 200L);
    }

    @NotNull
    public static TimedMatcher create(@NotNull Pattern pattern, @NotNull String str) {
        return new TimedMatcher(TimedMatcher.getMatcher(pattern, str, 200L));
    }

    @NotNull
    public static TimedMatcher create(@NotNull String rawPattern, @NotNull String str, long timeout) {
        return TimedMatcher.create(Pattern.compile(rawPattern), str, timeout);
    }

    @NotNull
    public static TimedMatcher create(@NotNull Pattern pattern, @NotNull String str, long timeout) {
        return new TimedMatcher(TimedMatcher.getMatcher(pattern, str, timeout));
    }

    @NotNull
    private static Matcher getMatcher(@NotNull Pattern pattern, @NotNull String text, long timeout) {
        if (timeout <= 0L) {
            return pattern.matcher(text);
        }
        return pattern.matcher(new TimeoutCharSequence(text, timeout));
    }

    @NotNull
    public Matcher getMatcher() {
        return this.matcher;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @NotNull
    public String replaceAll(@NotNull String with) {
        try {
            return this.matcher.replaceAll(with);
        }
        catch (MatcherTimeoutException exception) {
            if (this.isDebug()) {
                Engine.core().warn("Matcher " + exception.getTimeout() + "ms timeout error for replaceAll: '" + this.matcher.pattern().pattern() + "'.");
            }
            return "";
        }
    }

    public boolean matches() {
        try {
            return this.matcher.matches();
        }
        catch (MatcherTimeoutException exception) {
            if (this.isDebug()) {
                Engine.core().warn("Matcher " + exception.getTimeout() + "ms timeout error for: '" + this.matcher.pattern().pattern() + "'.");
            }
            return false;
        }
    }

    public boolean find() {
        try {
            return this.matcher.find();
        }
        catch (MatcherTimeoutException exception) {
            if (this.isDebug()) {
                Engine.core().warn("Matcher " + exception.getTimeout() + "ms timeout error for: '" + this.matcher.pattern().pattern() + "'.");
            }
            return false;
        }
    }
}

