/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.placeholder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.placeholder.PlaceholderList;
import su.nightexpress.nightcore.util.text.NightMessage;
import su.nightexpress.nightcore.util.text.TextRoot;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class Replacer {
    private final PlaceholderList<Object> placeholders;
    private final List<UnaryOperator<String>> replacers;

    public Replacer() {
        this.placeholders = new PlaceholderList();
        this.replacers = new ArrayList<UnaryOperator<String>>();
    }

    public Replacer(@NotNull Replacer other) {
        this.placeholders = new PlaceholderList<Object>(other.placeholders);
        this.replacers = new ArrayList<UnaryOperator<String>>(other.replacers);
    }

    @NotNull
    public static Replacer create() {
        return new Replacer();
    }

    public void clear() {
        this.placeholders.clear();
        this.replacers.clear();
    }

    @NotNull
    public List<UnaryOperator<String>> getReplacers() {
        ArrayList<UnaryOperator<String>> replacers = new ArrayList<UnaryOperator<String>>();
        replacers.add(this.placeholders.replacer(this));
        replacers.addAll(this.replacers);
        return replacers;
    }

    @NotNull
    public UnaryOperator<String> chained() {
        return this.getReplacers().stream().reduce((l, r) -> string -> (String)l.andThen(r).apply((String)string)).orElseGet(UnaryOperator::identity);
    }

    @NotNull
    public Replacer and(@NotNull Consumer<Replacer> consumer) {
        consumer.accept(this);
        return this;
    }

    @Deprecated
    @NotNull
    public TextRoot getReplaced(@NotNull String source) {
        return this.getReplaced(NightMessage.from(source));
    }

    @Deprecated
    @NotNull
    public TextRoot getReplaced(@NotNull TextRoot source) {
        return this.apply(source);
    }

    @Deprecated
    @NotNull
    public TextRoot apply(@NotNull TextRoot source) {
        TextRoot root = source.copy();
        this.getReplacers().forEach(root::replace);
        return root;
    }

    @Deprecated
    @NotNull
    public String getReplacedRaw(@NotNull String source) {
        return this.apply(source);
    }

    @NotNull
    public String apply(@NotNull String source) {
        String result = source;
        for (UnaryOperator<String> operator : this.getReplacers()) {
            result = (String)operator.apply(result);
        }
        return result;
    }

    @NotNull
    public List<String> apply(@NotNull List<String> list) {
        List<String> result = new ArrayList<String>(list);
        for (UnaryOperator<String> operator : this.getReplacers()) {
            result = Replacer.replaceList(result, operator);
        }
        return result;
    }

    @Deprecated
    @NotNull
    public ItemStack apply(@NotNull ItemStack itemStack) {
        ItemUtil.editMeta(itemStack, this::apply);
        return itemStack;
    }

    @Deprecated
    @NotNull
    public ItemMeta apply(@NotNull ItemMeta meta) {
        List lore = meta.getLore();
        if (Version.isAtLeast(Version.MC_1_21) && meta.hasItemName()) {
            meta.setItemName(this.apply(meta.getItemName()));
        }
        if (meta.hasDisplayName()) {
            meta.setDisplayName(this.apply(meta.getDisplayName()));
        }
        if (lore != null) {
            meta.setLore(this.apply(lore));
        }
        return meta;
    }

    @NotNull
    private static List<String> replaceList(@NotNull List<String> lore, @NotNull UnaryOperator<String> operator) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String line : lore) {
            if (!line.isBlank()) {
                if ((line = (String)operator.apply(line)).isBlank()) continue;
                replaced.addAll(Arrays.asList(ParserUtils.breakDownLineSplitters(line)));
                continue;
            }
            replaced.add(line);
        }
        return replaced;
    }

    @NotNull
    public Replacer replacePlaceholderAPI(@NotNull Player player) {
        if (!Plugins.hasPlaceholderAPI()) {
            return this;
        }
        return this.replaceOperator(line -> PlaceholderAPI.setPlaceholders((Player)player, (String)line));
    }

    @NotNull
    public Replacer replace(@NotNull String key, @NotNull Consumer<List<String>> replacer) {
        ArrayList<String> list = new ArrayList<String>();
        replacer.accept(list);
        return this.replace(key, list);
    }

    @NotNull
    public Replacer replace(@NotNull String key, @NotNull List<String> replacer) {
        return this.replacePlaceholder(key, () -> String.join((CharSequence)TagWrappers.BR, replacer));
    }

    @NotNull
    public <T> Replacer replace(@NotNull T source, @NotNull PlaceholderList<T> placeholders) {
        return this.replaceOperator(placeholders.replacer(source));
    }

    @NotNull
    public Replacer replace(@NotNull String key, @NotNull Supplier<String> value) {
        return this.replacePlaceholder(key, value);
    }

    @NotNull
    public Replacer replace(@NotNull String key, @NotNull Object value) {
        return this.replacePlaceholder(key, value);
    }

    @NotNull
    public Replacer replace(@NotNull UnaryOperator<String> replacer) {
        return this.replaceOperator(replacer);
    }

    @NotNull
    private Replacer replacePlaceholder(@NotNull String key, @NotNull Supplier<String> value) {
        this.placeholders.add(key, value);
        return this;
    }

    @NotNull
    private Replacer replacePlaceholder(@NotNull String key, @NotNull Object value) {
        this.placeholders.add(key, String.valueOf(value));
        return this;
    }

    @NotNull
    private Replacer replaceOperator(@NotNull UnaryOperator<String> replacer) {
        this.replacers.add(replacer);
        return this;
    }
}

