/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.blocktracker;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.blocktracker.PlayerBlockTracker;
import su.nightexpress.nightcore.util.blocktracker.TrackUtil;
import su.nightexpress.nightcore.util.blocktracker.TrackedChunk;

public class TrackedWorld {
    private final Long2ObjectMap<TrackedChunk> chunkMap = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());

    protected TrackedWorld() {
    }

    protected boolean isTracked(@NotNull Block block) {
        TrackedChunk trackedChunk = this.getChunkOf(block);
        return trackedChunk != null && trackedChunk.isTracked(block);
    }

    protected void add(@NotNull Block block) {
        TrackedChunk trackedChunk = this.getChunkOf(block);
        if (trackedChunk == null) {
            return;
        }
        trackedChunk.add(block);
    }

    protected void remove(@NotNull Block block) {
        TrackedChunk trackedChunk = this.getChunkOf(block);
        if (trackedChunk == null) {
            return;
        }
        trackedChunk.remove(block);
    }

    protected void initChunk(@NotNull Chunk chunk) {
        PersistentDataContainer container = chunk.getPersistentDataContainer();
        TrackedChunk trackedChunk = new TrackedChunk(container);
        this.chunkMap.put(TrackUtil.getChunkKey(chunk), (Object)trackedChunk);
    }

    protected void terminateChunk(@NotNull Chunk chunk) {
        TrackedChunk trackedChunk = (TrackedChunk)this.chunkMap.remove(TrackUtil.getChunkKey(chunk));
        if (trackedChunk == null) {
            return;
        }
        PersistentDataContainer container = chunk.getPersistentDataContainer();
        if (trackedChunk.isEmpty()) {
            container.remove(PlayerBlockTracker.TRACKED_DATA_KEY);
        } else {
            trackedChunk.saveTo(container);
        }
    }

    @Nullable
    private TrackedChunk getChunkOf(@NotNull Block block) {
        return (TrackedChunk)this.chunkMap.get(TrackUtil.getChunkKeyOfBlock(block));
    }
}

