/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.blocktracker;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.blocktracker.PlayerBlockTracker;
import su.nightexpress.nightcore.util.blocktracker.TrackUtil;

public class TrackedChunk {
    private final IntSet trackedBlockPositions;

    protected TrackedChunk(@NotNull PersistentDataContainer container) {
        int[] data = (int[])container.get(PlayerBlockTracker.TRACKED_DATA_KEY, PersistentDataType.INTEGER_ARRAY);
        this.trackedBlockPositions = data == null ? IntSets.synchronize((IntSet)new IntOpenHashSet()) : IntSets.synchronize((IntSet)new IntOpenHashSet(data));
    }

    protected void add(@NotNull Block block) {
        this.trackedBlockPositions.add(TrackUtil.getRelativeChunkPosition(block));
    }

    protected void remove(@NotNull Block block) {
        this.trackedBlockPositions.remove(TrackUtil.getRelativeChunkPosition(block));
    }

    protected boolean isTracked(@NotNull Block block) {
        return this.trackedBlockPositions.contains(TrackUtil.getRelativeChunkPosition(block));
    }

    protected void saveTo(@NotNull PersistentDataContainer container) {
        int[] data = this.trackedBlockPositions.toIntArray();
        container.set(PlayerBlockTracker.TRACKED_DATA_KEY, PersistentDataType.INTEGER_ARRAY, (Object)data);
    }

    protected boolean isEmpty() {
        return this.trackedBlockPositions.isEmpty();
    }
}

