/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.menu.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.menu.MenuViewer;
import su.nightexpress.nightcore.menu.api.Menu;
import su.nightexpress.nightcore.menu.click.ClickAction;

@Deprecated
public class ItemHandler {
    public static final String RETURN = "return";
    public static final String CLOSE = "close";
    public static final String NEXT_PAGE = "page_next";
    public static final String PREVIOUS_PAGE = "page_previous";
    private final String name;
    private final List<ClickAction> clickActions;
    private final Predicate<MenuViewer> visibilityPolicy;

    public ItemHandler() {
        this("default", null, null);
    }

    public ItemHandler(@NotNull String name) {
        this(name, null, null);
    }

    public ItemHandler(@NotNull String name, @Nullable ClickAction clickAction) {
        this(name, clickAction, null);
    }

    public ItemHandler(@NotNull String name, @Nullable ClickAction clickAction, @Nullable Predicate<MenuViewer> visibilityPolicy) {
        this.name = name.toLowerCase();
        this.clickActions = new ArrayList<ClickAction>();
        this.visibilityPolicy = visibilityPolicy;
        if (clickAction != null) {
            this.getClickActions().add(clickAction);
        }
    }

    @NotNull
    public static ItemHandler forClick(@NotNull ClickAction action) {
        return new ItemHandler(UUID.randomUUID().toString(), action);
    }

    @NotNull
    public static ItemHandler forNextPage(@NotNull Menu menu) {
        return new ItemHandler(NEXT_PAGE, (viewer, event) -> {
            if (viewer.getPage() < viewer.getPages()) {
                viewer.setPage(viewer.getPage() + 1);
                viewer.setUpdateTitle(true);
                menu.open(viewer.getPlayer());
            }
        }, viewer -> viewer.getPage() < viewer.getPages());
    }

    @NotNull
    public static ItemHandler forPreviousPage(@NotNull Menu menu) {
        return new ItemHandler(PREVIOUS_PAGE, (viewer, event) -> {
            if (viewer.getPage() > 1) {
                viewer.setPage(viewer.getPage() - 1);
                viewer.setUpdateTitle(true);
                menu.open(viewer.getPlayer());
            }
        }, viewer -> viewer.getPage() > 1);
    }

    @NotNull
    public static ItemHandler forClose(@NotNull Menu menu) {
        return new ItemHandler(CLOSE, (viewer, event) -> menu.runNextTick(() -> viewer.getPlayer().closeInventory()));
    }

    @NotNull
    public static ItemHandler forReturn(@NotNull Menu menu, @NotNull ClickAction action) {
        return new ItemHandler(RETURN, action);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<ClickAction> getClickActions() {
        return this.clickActions;
    }

    @Nullable
    public Predicate<MenuViewer> getVisibilityPolicy() {
        return this.visibilityPolicy;
    }
}

