/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale.entry;

import org.bukkit.Sound;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.locale.message.LangMessage;
import su.nightexpress.nightcore.locale.message.MessageData;
import su.nightexpress.nightcore.locale.message.impl.ChatMessage;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class MessageLocale
extends LangEntry<LangMessage> {
    private static final ConfigType<LangMessage> CONFIG_TYPE = ConfigType.of(LangMessage::read, FileConfig::set);

    public MessageLocale(@NonNull String path, @NonNull LangMessage defaultValue) {
        super(CONFIG_TYPE, path, defaultValue);
    }

    public static @NonNull MessageLocale message(@NonNull String path, @NonNull MessageData data, String ... text) {
        return MessageLocale.message(path, String.join((CharSequence)TagWrappers.BR, text), data);
    }

    public static @NonNull MessageLocale message(@NonNull String path, @NonNull String text, @NonNull MessageData data) {
        return new MessageLocale(path, LangMessage.createFromData(text, data));
    }

    public static @NonNull MessageLocale chat(@NonNull String path, @NonNull String text) {
        return MessageLocale.chat(path, new String[]{text});
    }

    public static @NonNull MessageLocale chat(@NonNull String path, String ... text) {
        return MessageLocale.chat(path, MessageData.chat().build(), text);
    }

    public static @NonNull MessageLocale chat(@NonNull String path, @NonNull Sound sound, String ... text) {
        return MessageLocale.chat(path, MessageData.chat().sound(sound).build(), text);
    }

    private static @NonNull MessageLocale chat(@NonNull String path, @NonNull MessageData data, String ... text) {
        return MessageLocale.message(path, String.join((CharSequence)TagWrappers.BR, text), data);
    }

    public static @NonNull MessageLocale title(@NonNull String path, @NonNull String title, @NonNull String subtitle) {
        return MessageLocale.title(path, title, subtitle, MessageData.titles().build());
    }

    public static @NonNull MessageLocale title(@NonNull String path, @NonNull String title, @NonNull String subtitle, @NonNull Sound sound) {
        return MessageLocale.title(path, title, subtitle, MessageData.titles().sound(sound).build());
    }

    public static @NonNull MessageLocale title(@NonNull String path, @NonNull String title, @NonNull String subtitle, int fade, int stay) {
        return MessageLocale.title(path, title, subtitle, MessageData.titles().titleTimes(fade, stay, fade).build());
    }

    public static @NonNull MessageLocale title(@NonNull String path, @NonNull String title, @NonNull String subtitle, int fade, int stay, @NonNull Sound sound) {
        return MessageLocale.title(path, title, subtitle, MessageData.titles().titleTimes(fade, stay, fade).sound(sound).build());
    }

    private static @NonNull MessageLocale title(@NonNull String path, @NonNull String title, @NonNull String subtitle, @NonNull MessageData data) {
        return MessageLocale.message(path, title + TagWrappers.BR + subtitle, data);
    }

    public static @NonNull MessageLocale actionBar(@NonNull String path, @NonNull String text) {
        return MessageLocale.message(path, text, MessageData.actionBar().build());
    }

    public static @NonNull MessageLocale actionBar(@NonNull String path, @NonNull String text, @NonNull Sound sound) {
        return MessageLocale.message(path, text, MessageData.actionBar().sound(sound).build());
    }

    @Override
    public void load(@NonNull NightPlugin plugin, @NonNull FileConfig config) {
        super.load(plugin, config);
        this.value = this.withPrefix(plugin);
    }

    public @NonNull LangMessage withPrefix(@NonNull NightPlugin plugin) {
        return this.withPrefix(plugin.getPrefix());
    }

    public @NonNull LangMessage withPrefix(@Nullable String prefix) {
        LangValue langValue = this.value;
        if (langValue instanceof ChatMessage) {
            ChatMessage chatMessage = (ChatMessage)langValue;
            return chatMessage.withPrefix(prefix);
        }
        return (LangMessage)this.value;
    }

    public @NonNull LangMessage message() {
        return (LangMessage)this.value;
    }
}

