/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale.entry;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class IconLocale
extends LangEntry<Value> {
    private static final ConfigType<Value> CONFIG_TYPE = ConfigType.of(Value::read, FileConfig::set);

    public IconLocale(@NonNull String path, @NonNull Value defaultValue) {
        super(CONFIG_TYPE, path, defaultValue);
    }

    public static @NonNull IconLocale create(@NonNull String path, @NonNull String name, @NonNull List<String> description) {
        return new IconLocale(path, new Value(name, description));
    }

    public @NonNull String getName() {
        return ((Value)this.value).name();
    }

    public @NonNull List<String> getLore() {
        return ((Value)this.value).lore();
    }

    public record Value(@NonNull String name, @NonNull List<String> lore) implements LangValue
    {
        public static @NonNull Value read(@NonNull FileConfig config, @NonNull String path) {
            String name = config.getString(path + ".Name", "null");
            List description = config.getStringList(path + ".Lore");
            return new Value(name, description);
        }

        @Override
        public void write(@NonNull FileConfig config, @NonNull String path) {
            config.set(path + ".Name", this.name);
            config.set(path + ".Lore", this.lore);
        }
    }

    public static class Builder {
        private final String path;
        private final List<String> lore;
        private String name;
        private TagWrapper accentColor;

        public Builder(@NonNull String path) {
            this.path = path;
            this.lore = new ArrayList<String>();
            this.accentColor = TagWrappers.SOFT_YELLOW;
        }

        public @NonNull IconLocale build() {
            Value value = new Value(this.name, this.lore);
            return new IconLocale(this.path, value);
        }

        public @NonNull Builder accentColor(@NonNull TagWrapper wrapper) {
            this.accentColor = wrapper;
            return this;
        }

        public @NonNull Builder br() {
            this.lore.add(" ");
            return this;
        }

        public @NonNull Builder name(@NonNull String name) {
            return this.name(name, this.accentColor);
        }

        public @NonNull Builder name(@NonNull String name, @NonNull TagWrapper color) {
            return this.rawName(color.and(TagWrappers.BOLD).wrap(name));
        }

        public @NonNull Builder rawName(@NonNull String name) {
            this.name = name;
            return this;
        }

        public @NonNull Builder appendInfo(String ... text) {
            return this.appendInfo(Lists.newList(text));
        }

        public @NonNull Builder appendInfo(@NonNull List<String> text) {
            this.lore.addAll(Lists.modify(text, TagWrappers.GRAY::wrap));
            return this;
        }

        public @NonNull Builder rawLore(String ... text) {
            this.lore.addAll(Lists.newList(text));
            return this;
        }

        public @NonNull Builder appendCurrent(@NonNull String type, @NonNull String value) {
            this.appendInfo(TagWrappers.DARK_GRAY.wrap("\u00bb ") + type + ": " + TagWrappers.WHITE.wrap(value));
            return this;
        }

        @Deprecated
        public @NonNull Builder appendCurrent(@NonNull String type, @NonNull String value, @NonNull TagWrapper color) {
            return this.appendCurrent(type, value);
        }

        public @NonNull Builder appendClick(@NonNull String clickText) {
            return this.appendClick(clickText, this.accentColor);
        }

        public @NonNull Builder appendClick(@NonNull String clickText, @NonNull TagWrapper color) {
            this.lore.add(color.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap(clickText)));
            return this;
        }
    }
}

