/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class DialogElementLocale
extends LangEntry<Value> {
    private static final ConfigType<Value> CONFIG_TYPE = ConfigType.of(Value::read, FileConfig::set);

    public DialogElementLocale(@NonNull String path, @NonNull Value defaultValue) {
        super(CONFIG_TYPE, path, defaultValue);
    }

    public static @NonNull DialogElementLocale create(@NonNull String path, String ... contents) {
        return DialogElementLocale.create(path, 200, contents);
    }

    public static @NonNull DialogElementLocale create(@NonNull String path, int width, String ... contents) {
        return new DialogElementLocale(path, new Value(String.join((CharSequence)TagWrappers.BR, contents), width));
    }

    public @NonNull DialogElementLocale replace(@NonNull UnaryOperator<String> operator) {
        return DialogElementLocale.create(this.path, this.width(), (String)operator.apply(this.contents()));
    }

    public @NonNull DialogElementLocale replace(@NonNull PlaceholderContext context) {
        return this.replace(context::apply);
    }

    public @NonNull String contents() {
        return ((Value)this.value).contents();
    }

    public int width() {
        return ((Value)this.value).width();
    }

    public record Value(@NonNull String contents, int width) implements LangValue
    {
        public static @NonNull Value read(@NonNull FileConfig config, @NonNull String path) {
            List list = config.getStringList(path + ".Contents");
            String contents = !list.isEmpty() ? String.join((CharSequence)TagWrappers.BR, list) : String.valueOf(config.getString(path + ".Contents"));
            int width = config.getInt(path + ".Width");
            return new Value(contents, width);
        }

        @Override
        public void write(@NonNull FileConfig config, @NonNull String path) {
            ArrayList list = new ArrayList();
            StringUtil.splitDelimiters(this.contents, list::add);
            config.set(path + ".Contents", list.size() != 1 ? list : list.getFirst());
            config.set(path + ".Width", this.width);
        }
    }
}

