/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale.entry;

import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;

public class ButtonLocale
extends LangEntry<Value> {
    private static final ConfigType<Value> CONFIG_TYPE = ConfigType.of(Value::load, FileConfig::set);

    public ButtonLocale(@NonNull String path, @NonNull Value defaultValue) {
        super(CONFIG_TYPE, path, defaultValue);
    }

    public static @NonNull ButtonLocale create(@NonNull String path, @NonNull String label) {
        return ButtonLocale.create(path, label, null);
    }

    public static @NonNull ButtonLocale create(@NonNull String path, @NonNull String label, int width) {
        return ButtonLocale.create(path, label, null, width);
    }

    public static @NonNull ButtonLocale create(@NonNull String path, @NonNull String label, @Nullable String tooltip) {
        return ButtonLocale.create(path, label, tooltip, 150);
    }

    public static @NonNull ButtonLocale create(@NonNull String path, @NonNull String label, @Nullable String tooltip, int width) {
        return new ButtonLocale(path, new Value(label, tooltip, width));
    }

    public @NonNull ButtonLocale replace(@NonNull UnaryOperator<String> operator) {
        return ButtonLocale.create(this.path, (String)operator.apply(((Value)this.value).label()), ((Value)this.value).tooltip == null ? null : (String)operator.apply(((Value)this.value).tooltip()), ((Value)this.value).width());
    }

    public @NonNull ButtonLocale replace(@NonNull PlaceholderContext context) {
        return this.replace(context::apply);
    }

    public record Value(@NonNull String label, @Nullable String tooltip, int width) implements LangValue
    {
        public static @NonNull Value load(@NonNull FileConfig config, @NonNull String path) {
            String label = String.valueOf(config.getString(path + ".Label"));
            String tooltip = config.getString(path + ".Tooltip");
            int width = config.getInt(path + ".Width");
            return new Value(label, tooltip, width);
        }

        @Override
        public void write(@NonNull FileConfig config, @NonNull String path) {
            config.set(path + ".Label", this.label);
            config.set(path + ".Tooltip", this.tooltip);
            config.set(path + ".Width", this.width);
        }
    }
}

