/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale;

import java.util.function.Function;
import org.bukkit.Keyed;
import org.bukkit.Sound;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.locale.LangElement;
import su.nightexpress.nightcore.locale.LangValue;
import su.nightexpress.nightcore.locale.entry.BooleanLocale;
import su.nightexpress.nightcore.locale.entry.ButtonLocale;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.entry.RegistryLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.locale.message.MessageData;
import su.nightexpress.nightcore.util.bridge.RegistryType;

public class LangEntry<T extends LangValue>
implements LangElement {
    protected final ConfigType<T> type;
    protected final String path;
    protected final T defaultValue;
    protected T value;

    public LangEntry(@NonNull ConfigType<T> type, @NonNull String path, @NonNull T defaultValue) {
        this.type = type;
        this.path = path;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void load(@NonNull NightPlugin plugin, @NonNull FileConfig config) {
        this.value = (LangValue)config.get(this.type, this.path, this.defaultValue, new String[0]);
    }

    public static @NonNull Builder builder(@NonNull String path) {
        return new Builder(path);
    }

    public static @NonNull IconLocale.Builder iconBuilder(@NonNull String path) {
        return new IconLocale.Builder(path);
    }

    @Override
    public @NonNull String getPath() {
        return this.path;
    }

    public @NonNull T getDefaultValue() {
        return this.defaultValue;
    }

    public @NonNull T value() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public static class Builder {
        private final String path;

        public Builder(@NonNull String path) {
            this.path = path;
        }

        public @NonNull MessageLocale message(@NonNull MessageData data, String ... text) {
            return MessageLocale.message(this.path, data, text);
        }

        public @NonNull MessageLocale chatMessage(@NonNull String text) {
            return this.chatMessage(new String[]{text});
        }

        public @NonNull MessageLocale chatMessage(String ... text) {
            return MessageLocale.chat(this.path, text);
        }

        public @NonNull MessageLocale chatMessage(@NonNull Sound sound, String ... text) {
            return MessageLocale.chat(this.path, sound, text);
        }

        public @NonNull MessageLocale titleMessage(@NonNull String title, @NonNull String subtitle) {
            return MessageLocale.title(this.path, title, subtitle);
        }

        public @NonNull MessageLocale titleMessage(@NonNull String title, @NonNull String subtitle, @NonNull Sound sound) {
            return MessageLocale.title(this.path, title, subtitle, sound);
        }

        public @NonNull MessageLocale titleMessage(@NonNull String title, @NonNull String subtitle, int fade, int stay) {
            return MessageLocale.title(this.path, title, subtitle, fade, stay);
        }

        public @NonNull MessageLocale titleMessage(@NonNull String title, @NonNull String subtitle, int fade, int stay, @NonNull Sound sound) {
            return MessageLocale.title(this.path, title, subtitle, fade, stay, sound);
        }

        public @NonNull MessageLocale actionBarMessage(@NonNull String text) {
            return MessageLocale.actionBar(this.path, text);
        }

        public @NonNull MessageLocale actionBarMessage(@NonNull String text, @NonNull Sound sound) {
            return MessageLocale.actionBar(this.path, text, sound);
        }

        public @NonNull BooleanLocale bool(@NonNull String onTrue, @NonNull String onFalse) {
            return BooleanLocale.create(this.path, onTrue, onFalse);
        }

        public @NonNull TextLocale text(@NonNull String text) {
            return TextLocale.create(this.path, text);
        }

        public @NonNull TextLocale text(String ... text) {
            return TextLocale.create(this.path, text);
        }

        public <E extends Enum<E>> @NonNull EnumLocale<E> enumeration(@NonNull Class<E> clazz) {
            return EnumLocale.create(this.path, clazz);
        }

        public <E extends Enum<E>> @NonNull EnumLocale<E> enumeration(@NonNull Class<E> clazz, @NonNull Function<E, String> defaultMapper) {
            return EnumLocale.create(this.path, clazz, defaultMapper);
        }

        public <E extends Keyed> @NonNull RegistryLocale<E> registry(@NonNull RegistryType<E> type) {
            return RegistryLocale.create(this.path, type);
        }

        public @NonNull ButtonLocale button(@NonNull String label) {
            return ButtonLocale.create(this.path, label);
        }

        public @NonNull ButtonLocale button(@NonNull String label, int width) {
            return ButtonLocale.create(this.path, label, width);
        }

        public @NonNull ButtonLocale button(@NonNull String label, @Nullable String tooltip) {
            return ButtonLocale.create(this.path, label, tooltip);
        }

        public @NonNull ButtonLocale button(@NonNull String label, @Nullable String tooltip, int width) {
            return ButtonLocale.create(this.path, label, tooltip, width);
        }

        public @NonNull DialogElementLocale dialogElement(String ... contents) {
            return DialogElementLocale.create(this.path, contents);
        }

        public @NonNull DialogElementLocale dialogElement(int width, String ... contents) {
            return DialogElementLocale.create(this.path, width, contents);
        }
    }
}

