/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db.statement.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.db.column.Column;
import su.nightexpress.nightcore.db.statement.PropertyAccessor;
import su.nightexpress.nightcore.db.statement.condition.Operator;

public class Wheres<T> {
    private final StringBuilder buffer = new StringBuilder();
    private final List<PropertyAccessor<T, Object>> parameters = new ArrayList<PropertyAccessor<T, Object>>();

    private Wheres() {
    }

    @NotNull
    public static <T> Wheres<T> where(@NotNull Column<?> column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return Wheres.where(column.getQuotedName(), operator, value);
    }

    @NotNull
    public static <T> Wheres<T> where(@NotNull String column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return new Wheres<T>().append(column, operator, value);
    }

    @NotNull
    public static <T> Wheres<T> whereUUID(@NotNull Column<?> column, @NotNull PropertyAccessor<T, UUID> value) {
        return Wheres.whereUUID(column.getQuotedName(), value);
    }

    @NotNull
    public static <T> Wheres<T> whereUUID(@NotNull String column, @NotNull PropertyAccessor<T, UUID> value) {
        return Wheres.where(column, Operator.EQUALS, (T o) -> ((UUID)value.access(o)).toString());
    }

    @NotNull
    public Wheres<T> and(@NotNull Column<?> column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return this.and(column.getQuotedName(), operator, value);
    }

    @NotNull
    public Wheres<T> and(@NotNull String column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return this.append("AND", column, operator, value);
    }

    @NotNull
    public Wheres<T> or(@NotNull Column<?> column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return this.or(column.getQuotedName(), operator, value);
    }

    @NotNull
    public Wheres<T> or(@NotNull String column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        return this.append("OR", column, operator, value);
    }

    @NotNull
    private Wheres<T> append(@NotNull String logic, @NotNull String column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        if (this.buffer.isEmpty()) {
            throw new IllegalStateException("'%s' must be preceded by initial where clause".formatted(logic));
        }
        this.buffer.append(" ").append(logic).append(" ");
        return this.append(column, operator, value);
    }

    @NotNull
    private Wheres<T> append(@NotNull String column, @NotNull Operator operator, @NotNull PropertyAccessor<T, Object> value) {
        if (operator == Operator.EQUALS_IGNORE_CASE) {
            this.buffer.append("LOWER(").append(column).append(") = LOWER(?)");
        } else {
            this.buffer.append(column).append(" ").append(operator.getLiteral()).append(" ?");
        }
        this.parameters.add(value);
        return this;
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public int size() {
        return this.parameters.size();
    }

    @NotNull
    public String toSql() {
        return this.buffer.toString();
    }

    @NotNull
    public List<PropertyAccessor<T, Object>> getParameters() {
        return this.parameters;
    }
}

