/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db.column;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.db.column.NullOption;
import su.nightexpress.nightcore.db.config.DatabaseType;

@FunctionalInterface
public interface ColumnDataType {
    public static final ColumnDataType BOOLEAN = type -> type == DatabaseType.SQLITE ? "INTEGER" : "TINYINT(1)";
    public static final ColumnDataType INTEGER = type -> type == DatabaseType.SQLITE ? "INTEGER" : "INT";
    public static final ColumnDataType LONG = type -> type == DatabaseType.SQLITE ? "INTEGER" : "BIGINT";
    public static final ColumnDataType FLOAT = type -> type == DatabaseType.SQLITE ? "REAL" : "FLOAT";
    public static final ColumnDataType DOUBLE = type -> type == DatabaseType.SQLITE ? "REAL" : "DOUBLE";
    public static final ColumnDataType TINY_TEXT = type -> type == DatabaseType.SQLITE ? "TEXT" : "TINYTEXT";
    public static final ColumnDataType MEDIUM_TEXT = type -> type == DatabaseType.SQLITE ? "TEXT" : "MEDIUMTEXT";
    public static final ColumnDataType LONG_TEXT = type -> type == DatabaseType.SQLITE ? "TEXT" : "LONGTEXT";
    public static final ColumnDataType JSON = type -> type == DatabaseType.SQLITE ? "TEXT" : "JSON";
    public static final ColumnDataType UUID = type -> type == DatabaseType.SQLITE ? "TEXT" : "VARCHAR(36)";

    @NotNull
    public static ColumnDataType string(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        return type -> type == DatabaseType.SQLITE ? "TEXT" : "VARCHAR(" + length + ") CHARACTER SET utf8mb4";
    }

    @NotNull
    public String toSql(@NotNull DatabaseType var1);

    @NotNull
    default public String toSql(@NotNull DatabaseType type, @NotNull NullOption nullOption) {
        String sql = this.toSql(type);
        return nullOption == NullOption.NULLABLE ? sql : sql + " NOT NULL";
    }
}

