/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.database.sql;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.database.DatabaseType;
import su.nightexpress.nightcore.database.sql.SQLValue;
import su.nightexpress.nightcore.database.sql.column.ColumnType;

@Deprecated
public class SQLColumn {
    private final String name;
    private final String nameEscaped;
    private final ColumnType type;
    private final int length;

    public SQLColumn(@NotNull String name, @NotNull ColumnType type, int length) {
        this(name, "`" + name + "`", type, length);
    }

    public SQLColumn(@NotNull String name, @NotNull String nameEscaped, @NotNull ColumnType type, int length) {
        this.name = name;
        this.nameEscaped = nameEscaped;
        this.type = type;
        this.length = length;
    }

    @NotNull
    public static SQLColumn of(@NotNull String name, @NotNull ColumnType type) {
        return SQLColumn.of(name, type, -1);
    }

    @NotNull
    public static SQLColumn of(@NotNull String name, @NotNull ColumnType type, int length) {
        return new SQLColumn(name, type, length);
    }

    @Deprecated
    @NotNull
    public SQLColumn asLowerCase() {
        String name = "LOWER(" + this.getName() + ")";
        return new SQLColumn(name, name, this.getType(), this.getLength());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getNameEscaped() {
        return this.nameEscaped;
    }

    @NotNull
    public String getNameLowercase() {
        return "LOWER(" + this.getName() + ")";
    }

    @NotNull
    public ColumnType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    @NotNull
    public String formatType(@NotNull DatabaseType databaseType) {
        return this.getType().getFormer().build(databaseType, this.getLength());
    }

    @NotNull
    public SQLValue toValue(@NotNull Object value) {
        return SQLValue.of(this, String.valueOf(value));
    }
}

