/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.configuration;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;

public class ConfigType<T> {
    private final Loader<T> loader;
    private final Writer<T> writer;

    public ConfigType(@NotNull Loader<T> loader, @NotNull Writer<T> writer) {
        this.loader = loader;
        this.writer = writer;
    }

    @NotNull
    public static <T> ConfigType<T> of(@NotNull Loader<T> loader, @NotNull Writer<T> writer) {
        return new ConfigType<T>(loader, writer);
    }

    @NotNull
    public static <T> ConfigType<T> of(@NotNull Loader<T> loader) {
        return ConfigType.of(loader, FileConfig::set);
    }

    @NotNull
    public Optional<T> read(@NotNull FileConfig config, @NotNull String path) {
        if (!config.contains(path)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.loader.read(config, path));
    }

    @NotNull
    public T read(@NotNull FileConfig config, @NotNull String path, @NotNull T defaultValue) {
        return this.read(config, path).orElse(defaultValue);
    }

    public void write(@NotNull FileConfig config, @NotNull String path, @NotNull T value) {
        this.writer.write(config, path, value);
    }

    @FunctionalInterface
    public static interface Loader<T> {
        @Nullable
        public T read(@NotNull FileConfig var1, @NotNull String var2);
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public void write(@NotNull FileConfig var1, @NotNull String var2, @NotNull T var3);
    }
}

