/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.config;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.bukkit.configuration.MemorySection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.ReadFunction;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.TriFunction;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.bukkit.NightSound;
import su.nightexpress.nightcore.util.wrapper.UniFormatter;
import su.nightexpress.nightcore.util.wrapper.UniParticle;
import su.nightexpress.nightcore.util.wrapper.UniSound;

public class ConfigValue<T> {
    private final String path;
    private final T defaultValue;
    private final String[] description;
    private final Loader<T> reader;
    private final Writer<T> writer;
    private T value;
    private UnaryOperator<T> onRead;

    public ConfigValue(@NotNull String path, @NotNull Loader<T> reader, @NotNull Writer<T> writer, @NotNull T defaultValue, String ... description) {
        this.path = path;
        this.description = description == null ? new String[]{} : description;
        this.reader = reader;
        this.writer = writer;
        this.defaultValue = defaultValue;
    }

    @Deprecated
    public ConfigValue(@NotNull String path, @NotNull Reader<T> reader, @NotNull Writer<T> writer, @NotNull T defaultValue, String ... description) {
        this(path, reader.update(), writer, defaultValue, description);
    }

    @NotNull
    private static <T> ConfigValue<T> create(@NotNull String path, @NotNull Loader<T> reader, @NotNull Writer<T> writer, @NotNull T defaultValue, String ... description) {
        return new ConfigValue<T>(path, reader, writer, defaultValue, description);
    }

    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Loader<T> reader, @NotNull Writer<T> writer, @NotNull Supplier<T> defaultValue, String ... description) {
        return ConfigValue.create(path, reader, writer, defaultValue.get(), description);
    }

    @Deprecated
    @NotNull
    private static <T> ConfigValue<T> create(@NotNull String path, @NotNull Reader<T> reader, @NotNull Writer<T> writer, @NotNull T defaultValue, String ... description) {
        return new ConfigValue<T>(path, reader.update(), writer, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Reader<T> reader, @NotNull Writer<T> writer, @NotNull Supplier<T> defaultValue, String ... description) {
        return ConfigValue.create(path, reader, writer, defaultValue.get(), description);
    }

    @Deprecated
    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Reader<T> reader, @NotNull T defaultValue, String ... description) {
        return ConfigValue.create(path, reader.update(), FileConfig::set, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Reader<T> reader, @NotNull Supplier<T> defaultValue, String ... description) {
        return ConfigValue.create(path, reader.update(), FileConfig::set, defaultValue, description);
    }

    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Loader<T> reader, @NotNull T defaultValue, String ... description) {
        return ConfigValue.create(path, reader, FileConfig::set, defaultValue, description);
    }

    @NotNull
    public static <T> ConfigValue<T> create(@NotNull String path, @NotNull Loader<T> reader, @NotNull Supplier<T> defaultValue, String ... description) {
        return ConfigValue.create(path, reader, FileConfig::set, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<Boolean> create(@NotNull String path, boolean defaultValue, String ... description) {
        return ConfigValue.create(path, MemorySection::getBoolean, Boolean.valueOf(defaultValue), description);
    }

    @NotNull
    public static ConfigValue<Integer> create(@NotNull String path, int defaultValue, String ... description) {
        return ConfigValue.create(path, MemorySection::getInt, Integer.valueOf(defaultValue), description);
    }

    @NotNull
    public static ConfigValue<int[]> create(@NotNull String path, int[] defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getIntArray, FileConfig::setIntArray, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<Double> create(@NotNull String path, double defaultValue, String ... description) {
        return ConfigValue.create(path, MemorySection::getDouble, Double.valueOf(defaultValue), description);
    }

    @NotNull
    public static ConfigValue<Long> create(@NotNull String path, long defaultValue, String ... description) {
        return ConfigValue.create(path, MemorySection::getLong, Long.valueOf(defaultValue), description);
    }

    @NotNull
    public static ConfigValue<String> create(@NotNull String path, @NotNull String defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getString, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<String[]> create(@NotNull String path, @NotNull String[] defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getStringArray, FileConfig::setStringArray, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<List<String>> create(@NotNull String path, @NotNull List<String> defaultValue, String ... description) {
        return ConfigValue.create(path, MemorySection::getStringList, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<Set<String>> create(@NotNull String path, @NotNull Set<String> defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getStringSet, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static ConfigValue<ItemStack> create(@NotNull String path, @NotNull ItemStack defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getItem, FileConfig::setItem, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<NightItem> create(@NotNull String path, @NotNull NightItem defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getCosmeticItem, FileConfig::set, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static ConfigValue<UniSound> create(@NotNull String path, @NotNull UniSound defaultValue, String ... description) {
        Writer<UniSound> writer = (cfg, path1, obj) -> obj.write(cfg, path1);
        return ConfigValue.create(path, UniSound::read, writer, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<NightSound> create(@NotNull String path, @NotNull NightSound defaultValue, String ... description) {
        return ConfigValue.create(path, FileConfig::getSound, FileConfig::set, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<su.nightexpress.nightcore.bridge.wrap.NightSound> create(@NotNull String path, @NotNull su.nightexpress.nightcore.bridge.wrap.NightSound defaultValue, String ... description) {
        return ConfigValue.create(path, (FileConfig config, String path2) -> config.readSound(path2), FileConfig::set, defaultValue, description);
    }

    @NotNull
    public static ConfigValue<UniParticle> create(@NotNull String path, @NotNull UniParticle defaultValue, String ... description) {
        Loader<UniParticle> reader = UniParticle::read;
        Writer<UniParticle> writer = (cfg, path1, obj) -> obj.write(cfg, path1);
        return ConfigValue.create(path, reader, writer, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static ConfigValue<UniFormatter> create(@NotNull String path, @NotNull UniFormatter defaultValue, String ... description) {
        return ConfigValue.create(path, UniFormatter::read, defaultValue, description);
    }

    @NotNull
    public static <E extends Enum<E>> ConfigValue<E> create(@NotNull String path, @NotNull Class<E> clazz, @NotNull E defaultValue, String ... description) {
        Loader<Enum> reader = (cfg, path1) -> cfg.getEnum(path1, clazz);
        Writer<Enum> writer = (cfg, path1, obj) -> cfg.set(path1, obj.name());
        return ConfigValue.create(path, reader, writer, defaultValue, description);
    }

    @NotNull
    public static <V> ConfigValue<Set<V>> forSet(@NotNull String path, @NotNull Function<String, V> reader, @NotNull Writer<Set<V>> writer, @NotNull Supplier<Set<V>> defaultValue, String ... description) {
        return ConfigValue.forSet(path, reader, writer, defaultValue.get(), description);
    }

    @NotNull
    public static <V> ConfigValue<Set<V>> forSet(@NotNull String path, @NotNull Function<String, V> valFun, @NotNull Writer<Set<V>> writer, @NotNull Set<V> defaultValue, String ... description) {
        Loader<Set> reader = (cfg, path1) -> cfg.getStringSet(path1).stream().map(valFun).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        return ConfigValue.create(path, reader, writer, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <K, V> ConfigValue<Map<K, V>> forMap(@NotNull String path, @NotNull Function<String, K> keyFun, @NotNull TriFunction<FileConfig, String, String, V> valFun, @NotNull Writer<Map<K, V>> writer, @NotNull Supplier<Map<K, V>> defaultValue, String ... description) {
        return ConfigValue.forMap(path, keyFun, valFun, writer, defaultValue.get(), description);
    }

    @Deprecated
    @NotNull
    public static <K, V> ConfigValue<Map<K, V>> forMap(@NotNull String path, @NotNull Function<String, K> keyFun, @NotNull TriFunction<FileConfig, String, String, V> valFun, @NotNull Writer<Map<K, V>> writer, @NotNull Map<K, V> defaultValue, String ... description) {
        return ConfigValue.forMap(path, keyFun, valFun, LinkedHashMap::new, writer, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <K, V> ConfigValue<TreeMap<K, V>> forTreeMap(@NotNull String path, @NotNull Function<String, K> keyFun, @NotNull TriFunction<FileConfig, String, String, V> valFun, @NotNull Writer<TreeMap<K, V>> writer, @NotNull Supplier<TreeMap<K, V>> defaultValue, String ... description) {
        return ConfigValue.forTreeMap(path, keyFun, valFun, writer, defaultValue.get(), description);
    }

    @Deprecated
    @NotNull
    public static <K, V> ConfigValue<TreeMap<K, V>> forTreeMap(@NotNull String path, @NotNull Function<String, K> keyFun, @NotNull TriFunction<FileConfig, String, String, V> valFun, @NotNull Writer<TreeMap<K, V>> writer, @NotNull TreeMap<K, V> defaultValue, String ... description) {
        return ConfigValue.forMap(path, keyFun, valFun, TreeMap::new, writer, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <K, V, M extends Map<K, V>> ConfigValue<M> forMap(@NotNull String path, @NotNull Function<String, K> keyFun, @NotNull TriFunction<FileConfig, String, String, V> valFun, @NotNull Supplier<M> mapSupplier, @NotNull Writer<M> writer, @NotNull M defaultValue, String ... description) {
        Loader<Map> reader = (cfg, path1) -> {
            Map map = (Map)mapSupplier.get();
            for (String id : cfg.getSection(path1)) {
                Object key = keyFun.apply(id);
                Object val = valFun.apply(cfg, path1, id);
                if (key == null || val == null) continue;
                map.put(key, val);
            }
            return map;
        };
        return ConfigValue.create(path, reader, writer, defaultValue, description);
    }

    @NotNull
    public static <K, V> ConfigValue<Map<K, V>> forMap(@NotNull String path, @NotNull Function<String, K> keyReadFun, @NotNull Function<K, String> keyWriteFun, @NotNull ReadFunction<V> valReadFun, @NotNull Consumer<Map<K, V>> defaultValue, String ... description) {
        Loader<Map> reader = (config, readPath) -> {
            LinkedHashMap map = new LinkedHashMap();
            for (String keyRaw : config.getSection(readPath)) {
                Object key = keyReadFun.apply(keyRaw);
                Object val = valReadFun.read(config, readPath + "." + keyRaw, keyRaw);
                if (key == null || val == null) continue;
                map.put(key, val);
            }
            return map;
        };
        Writer<Map> writer = (config, writePath, map) -> map.forEach((key, value) -> {
            String keyRaw = (String)keyWriteFun.apply(key);
            config.set(writePath + "." + keyRaw, value);
        });
        LinkedHashMap defaultMap = new LinkedHashMap();
        defaultValue.accept(defaultMap);
        return ConfigValue.create(path, reader, writer, defaultMap, description);
    }

    @NotNull
    public static <K, V extends Writeable> ConfigValue<Map<K, V>> forMap(@NotNull String path, @NotNull Function<String, K> keyReadFun, @NotNull Function<K, String> keyWriteFun, @NotNull BiFunction<FileConfig, String, V> valReadFun, @NotNull Consumer<Map<K, V>> defaultValue, String ... description) {
        return ConfigValue.forMap(path, keyReadFun, keyWriteFun, (FileConfig cfg, String path2, String id) -> (Writeable)valReadFun.apply(cfg, path2), defaultValue, description);
    }

    @NotNull
    public static <V> ConfigValue<Map<String, V>> forMapById(@NotNull String path, @NotNull BiFunction<FileConfig, String, V> valReadFun, @NotNull Consumer<Map<String, V>> defaultValue, String ... description) {
        return ConfigValue.forMapById(path, (FileConfig cfg, String path2, String id) -> valReadFun.apply(cfg, path2), defaultValue, description);
    }

    @NotNull
    public static <V> ConfigValue<Map<String, V>> forMapById(@NotNull String path, @NotNull ReadFunction<V> valReadFun, @NotNull Consumer<Map<String, V>> defaultValue, String ... description) {
        return ConfigValue.forMap(path, String::toLowerCase, (K key) -> key, valReadFun, defaultValue, description);
    }

    @NotNull
    public static <E extends Enum<E>, V> ConfigValue<Map<E, V>> forMapByEnum(@NotNull String path, @NotNull Class<E> clazz, @NotNull BiFunction<FileConfig, String, V> valReadFun, @NotNull Consumer<Map<E, V>> defaultValue, String ... description) {
        return ConfigValue.forMapByEnum(path, clazz, (FileConfig cfg, String path2, String id) -> valReadFun.apply(cfg, path2), defaultValue, description);
    }

    @NotNull
    public static <E extends Enum<E>, V> ConfigValue<Map<E, V>> forMapByEnum(@NotNull String path, @NotNull Class<E> clazz, @NotNull ReadFunction<V> valReadFun, @NotNull Consumer<Map<E, V>> defaultValue, String ... description) {
        return ConfigValue.forMap(path, (String str) -> StringUtil.getEnum(str, clazz).orElse(null), Enum::name, valReadFun, defaultValue, description);
    }

    @Deprecated
    @NotNull
    public static <V> ConfigValue<Map<String, V>> forMap(@NotNull String path, @NotNull TriFunction<FileConfig, String, String, V> function, @NotNull Writer<Map<String, V>> writer, @NotNull Supplier<Map<String, V>> defaultValue, String ... description) {
        return ConfigValue.forMap(path, String::toLowerCase, function, writer, defaultValue.get(), description);
    }

    @Deprecated
    @NotNull
    public static <V> ConfigValue<Map<String, V>> forMap(@NotNull String path, @NotNull TriFunction<FileConfig, String, String, V> function, @NotNull Writer<Map<String, V>> writer, @NotNull Map<String, V> defaultValue, String ... description) {
        return ConfigValue.forMap(path, String::toLowerCase, function, writer, defaultValue, description);
    }

    @NotNull
    public ConfigValue<T> onRead(@NotNull UnaryOperator<T> onRead) {
        this.onRead = onRead;
        return this;
    }

    @NotNull
    public ConfigValue<T> whenRead(@NotNull Consumer<T> onRead) {
        this.onRead(object -> {
            onRead.accept(object);
            return object;
        });
        return this;
    }

    @NotNull
    public T read(@NotNull FileConfig config) {
        if (!config.contains(this.path)) {
            this.write(config);
        }
        if (this.description.length > 0 && !this.description[0].isEmpty()) {
            config.setComments(this.path, this.description);
        }
        UnaryOperator<T> postRead = this.onRead == null ? value -> value : this.onRead;
        T read = this.reader.read(config, this.path);
        if (read == null) {
            read = this.defaultValue;
        }
        this.value = postRead.apply(read);
        return this.value;
    }

    public void write(@NotNull FileConfig config) {
        this.getWriter().write(config, this.getPath(), this.get());
    }

    public boolean remove(@NotNull FileConfig config) {
        return config.remove(this.getPath());
    }

    @NotNull
    public T get() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public void set(@NotNull T value) {
        this.value = value;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String[] getDescription() {
        return this.description;
    }

    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public Loader<T> getReader() {
        return this.reader;
    }

    @NotNull
    public Writer<T> getWriter() {
        return this.writer;
    }

    public static interface Loader<T> {
        @Nullable
        public T read(@NotNull FileConfig var1, @NotNull String var2);
    }

    public static interface Writer<T> {
        public void write(@NotNull FileConfig var1, @NotNull String var2, @NotNull T var3);
    }

    @Deprecated
    public static interface Reader<T> {
        @NotNull
        public T read(@NotNull FileConfig var1, @NotNull String var2, T var3);

        default public Loader<T> update() {
            return (cfg, path) -> this.read(cfg, path, null);
        }
    }
}

