/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.text.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.text.NightAbstractComponent;
import su.nightexpress.nightcore.bridge.text.NightStyle;
import su.nightexpress.nightcore.bridge.text.adapter.TextComponentAdapter;
import su.nightexpress.nightcore.bridge.text.contents.NightObjectContents;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class NightObjectComponent
extends NightAbstractComponent {
    private final NightObjectContents contents;

    private NightObjectComponent(@NotNull List<? extends NightComponent> children, @NotNull NightStyle style, @NotNull NightObjectContents contents) {
        super(children, style);
        this.contents = contents;
    }

    @NotNull
    public static NightObjectComponent create(@NotNull NightStyle style, @NotNull NightObjectContents contents) {
        return new NightObjectComponent(Collections.emptyList(), style, contents);
    }

    @Override
    @NotNull
    public <T> T adapt(@NotNull TextComponentAdapter<T> adapter) {
        return adapter.adaptComponent(this);
    }

    @NotNull
    public NightObjectContents contents() {
        return this.contents;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NightObjectComponent)) {
            return false;
        }
        NightObjectComponent that = (NightObjectComponent)other;
        return Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hashCode(this.contents);
    }

    public String toString() {
        return "NightObjectComponent{contents=" + String.valueOf(this.contents) + "}";
    }

    @Override
    @NotNull
    public NightObjectComponent children(@NotNull List<? extends NightComponent> children) {
        return new NightObjectComponent(children, this.style, this.contents);
    }

    @Override
    @NotNull
    public NightObjectComponent style(@NotNull NightStyle style) {
        if (Objects.equals(this.style, style)) {
            return this;
        }
        return new NightObjectComponent(this.children, style, this.contents);
    }

    @NotNull
    public NightObjectComponent contents(@NotNull NightObjectContents contents) {
        if (Objects.equals(this.contents, contents)) {
            return this;
        }
        return new NightObjectComponent(this.children, this.style, contents);
    }
}

