/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.text.contents;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.bridge.text.adapter.ObjectContentsAdapter;
import su.nightexpress.nightcore.bridge.text.contents.NightObjectContents;

public class NightPlayerHeadObjectContents
implements NightObjectContents {
    public static final boolean DEFAULT_HAT = true;
    @Nullable
    private final String name;
    @Nullable
    private final UUID id;
    private final List<NightProfileProperty> properties;
    private final boolean hat;
    @Nullable
    private final NightKey texture;

    NightPlayerHeadObjectContents(@Nullable String name, @Nullable UUID id, @NotNull List<NightProfileProperty> properties, boolean hat, @Nullable NightKey texture) {
        this.name = name;
        this.id = id;
        this.properties = properties.isEmpty() ? Collections.emptyList() : List.copyOf(properties);
        this.hat = hat;
        this.texture = texture;
    }

    @NotNull
    public static NightProfileProperty property(@NotNull String name, @NotNull String value) {
        return new NightProfileProperty(name, value, null);
    }

    @NotNull
    public static NightProfileProperty property(@NotNull String name, @NotNull String value, @Nullable String signature) {
        return new NightProfileProperty(name, value, signature);
    }

    @Override
    @NotNull
    public <T> T adapt(@NotNull ObjectContentsAdapter<T> adapter) {
        return adapter.adaptContents(this);
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public UUID id() {
        return this.id;
    }

    @NotNull
    public List<NightProfileProperty> profileProperties() {
        return this.properties;
    }

    public boolean hat() {
        return this.hat;
    }

    @Nullable
    public NightKey texture() {
        return this.texture;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NightPlayerHeadObjectContents)) {
            return false;
        }
        NightPlayerHeadObjectContents that = (NightPlayerHeadObjectContents)o;
        return this.hat == that.hat && Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.properties, that.properties) && Objects.equals(this.texture, that.texture);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.properties, this.hat, this.texture);
    }

    public String toString() {
        return "NightPlayerHeadObjectContents{name='" + this.name + "', id=" + String.valueOf(this.id) + ", properties=" + String.valueOf(this.properties) + ", hat=" + this.hat + ", texture=" + String.valueOf(this.texture) + "}";
    }

    public static final class NightProfileProperty {
        private final String name;
        private final String value;
        @Nullable
        private final String signature;

        NightProfileProperty(@NotNull String name, @NotNull String value, @Nullable String signature) {
            this.name = name;
            this.value = value;
            this.signature = signature;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        @Nullable
        public String signature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NightProfileProperty)) {
                return false;
            }
            NightProfileProperty that = (NightProfileProperty)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.signature, that.signature);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.signature);
        }

        public String toString() {
            return "ProfilePropertyImpl{name='" + this.name + "', value='" + this.value + "', signature='" + this.signature + "'}";
        }
    }
}

