/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.tag.handler;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.text.event.NightClickEvent;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Numbers;
import su.nightexpress.nightcore.util.text.event.ClickEvents;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.entry.EntryGroup;
import su.nightexpress.nightcore.util.text.night.tag.TagContent;
import su.nightexpress.nightcore.util.text.night.tag.handler.ClassicTagHandler;

public class ClickTagHandler
extends ClassicTagHandler {
    @Override
    protected void onHandleOpen(@NotNull EntryGroup group, @Nullable String tagContent) {
        NightClickEvent clickEvent;
        if (tagContent == null) {
            return;
        }
        TagContent content = ParserUtils.parseInnerContent(tagContent);
        String value = content.second();
        if (value == null) {
            return;
        }
        NightClickEvent.Action action = Enums.get(content.first(), NightClickEvent.Action.class);
        if (action == null) {
            return;
        }
        switch (action) {
            default: {
                throw new MatchException(null, null);
            }
            case COPY_TO_CLIPBOARD: {
                NightClickEvent nightClickEvent = ClickEvents.copyToClipboard(value);
                break;
            }
            case SUGGEST_COMMAND: {
                NightClickEvent nightClickEvent = ClickEvents.suggestCommand(value);
                break;
            }
            case RUN_COMMAND: {
                NightClickEvent nightClickEvent = ClickEvents.runCommand(value);
                break;
            }
            case CHANGE_PAGE: {
                NightClickEvent nightClickEvent = ClickEvents.changePage(Numbers.getIntegerAbs(value));
                break;
            }
            case OPEN_FILE: {
                NightClickEvent nightClickEvent = ClickEvents.openFile(value);
                break;
            }
            case OPEN_URL: {
                NightClickEvent nightClickEvent = ClickEvents.openUrl(value);
                break;
            }
            case SHOW_DIALOG: {
                NightClickEvent nightClickEvent = null;
                break;
            }
            case CUSTOM: {
                NightClickEvent nightClickEvent = clickEvent = null;
            }
        }
        if (clickEvent == null) {
            return;
        }
        group.setStyle(style -> style.clickEvent(clickEvent));
    }

    @Override
    protected void onHandleClose(@NotNull EntryGroup group) {
    }
}

