/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.Enums;

public class Lists {
    public static int indexOf(Object[] array, @NotNull Object objectToFind) {
        return Lists.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, @NotNull Object objectToFind, int startIndex) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (!array.getClass().getComponentType().isInstance(objectToFind)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int index = startIndex; index < array.length; ++index) {
            if (!objectToFind.equals(array[index])) continue;
            return index;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return Lists.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return Lists.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int index = startIndex; index < array.length; ++index) {
            if (valueToFind != array[index]) continue;
            return index;
        }
        return -1;
    }

    public static boolean contains(int[] array, int valueToFind) {
        return Lists.indexOf(array, valueToFind) != -1;
    }

    @NotNull
    public static <T, R> Set<R> modify(@NotNull Set<T> set, @NotNull Function<T, R> function) {
        return set.stream().map(function).collect(Collectors.toCollection(HashSet::new));
    }

    @NotNull
    public static <T, R> List<R> modify(@NotNull List<T> set, @NotNull Function<T, R> function) {
        return set.stream().map(function).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    public static <T> List<List<T>> split(@NotNull List<T> list, int targetSize) {
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        if (targetSize <= 0) {
            return lists;
        }
        for (int index = 0; index < list.size(); index += targetSize) {
            lists.add(list.subList(index, Math.min(index + targetSize, list.size())));
        }
        return lists;
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> origin, @NotNull String var, String ... with) {
        return Lists.replace(origin, var, Arrays.asList(with));
    }

    @NotNull
    public static List<String> replace(@NotNull List<String> origin, @NotNull String var, @NotNull List<String> with) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String line : origin) {
            if (line.equalsIgnoreCase(var)) {
                replaced.addAll(with);
                continue;
            }
            replaced.add(line);
        }
        return replaced;
    }

    @Deprecated
    @NotNull
    public static List<String> stripEmpty(@NotNull List<String> original) {
        ArrayList<String> stripped = new ArrayList<String>();
        for (int index = 0; index < original.size(); ++index) {
            String line = original.get(index);
            if (line.isEmpty()) {
                String last;
                String string = last = stripped.isEmpty() ? null : (String)stripped.getLast();
                if (last == null || last.isEmpty() || index == original.size() - 1) continue;
            }
            stripped.add(line);
        }
        return stripped;
    }

    @NotNull
    public static List<String> getSequentialMatches(@NotNull List<String> results, @NotNull String input) {
        if (input.isBlank()) {
            return results;
        }
        char[] inputChars = input.toCharArray();
        ArrayList<String> goods = new ArrayList<String>();
        block0: for (String resultItem : results) {
            int itemLength = resultItem.length();
            if (input.length() > itemLength) continue;
            int lastIndex = -1;
            for (char letter : inputChars) {
                int nextIndex = lastIndex;
                if (nextIndex < 0) {
                    nextIndex = 0;
                } else if (nextIndex < itemLength - 1) {
                    ++nextIndex;
                }
                letter = Character.toLowerCase(letter);
                int index = resultItem.toLowerCase().indexOf(letter, nextIndex);
                if (index <= lastIndex) continue block0;
                lastIndex = index;
            }
            goods.add(resultItem);
        }
        return goods;
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sortAscent(@NotNull Map<K, V> map) {
        return Lists.sort(map, Map.Entry.comparingByValue());
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sortDescent(@NotNull Map<K, V> map) {
        return Lists.sort(map, Collections.reverseOrder(Map.Entry.comparingByValue()));
    }

    @SafeVarargs
    @NotNull
    public static <T> List<T> newList(T ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> newSet(T ... values) {
        HashSet list = new HashSet();
        Collections.addAll(list, values);
        return list;
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sort(@NotNull Map<K, V> map, @NotNull Comparator<Map.Entry<K, V>> comparator) {
        return new LinkedList<Map.Entry<K, V>>(map.entrySet()).stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (old, nev) -> nev, LinkedHashMap::new));
    }

    @Deprecated
    @NotNull
    public static List<String> getEnums(@NotNull Class<? extends Enum<?>> clazz) {
        return Enums.getNames(clazz);
    }

    @NotNull
    public static <T extends Enum<T>> T next(@NotNull Enum<T> numeration) {
        return Lists.shifted(numeration, 1);
    }

    @NotNull
    public static <T extends Enum<T>> T next(@NotNull Enum<T> numeration, @NotNull Predicate<T> predicate) {
        return Lists.shifted(numeration, 1, predicate);
    }

    @NotNull
    public static <T extends Enum<T>> T previous(@NotNull Enum<T> numeration) {
        return Lists.shifted(numeration, -1);
    }

    @NotNull
    public static <T extends Enum<T>> T previous(@NotNull Enum<T> numeration, @NotNull Predicate<T> predicate) {
        return Lists.shifted(numeration, -1, predicate);
    }

    @NotNull
    public static <T extends Enum<T>> T shifted(@NotNull Enum<T> numeration, int shift) {
        return Lists.shifted(numeration, shift, null);
    }

    @NotNull
    private static <T extends Enum<T>> T shifted(@NotNull Enum<T> numeration, int shift, @Nullable Predicate<T> predicate) {
        Enum[] values = (Enum[])numeration.getDeclaringClass().getEnumConstants();
        return (T)Lists.shifted((Enum[])values, numeration, (int)shift, predicate);
    }

    @NotNull
    private static <T extends Enum<T>> T shifted(T[] values, @NotNull Enum<T> origin, int shift, @Nullable Predicate<T> predicate) {
        if (predicate != null) {
            Enum source = (Enum)origin.getDeclaringClass().cast(origin);
            ArrayList<T> filtered = new ArrayList<T>(Arrays.asList(values));
            filtered.removeIf(num -> !predicate.test(num) && num != source);
            int currentIndex = filtered.indexOf(source);
            if (currentIndex < 0 | filtered.isEmpty()) {
                return (T)source;
            }
            return (T)((Enum)Lists.shifted(filtered, currentIndex, shift));
        }
        return (T)((Enum)Lists.shifted(values, origin.ordinal(), shift));
    }

    @NotNull
    public static <T> T shifted(T[] values, int currentIndex, int shift) {
        int index = currentIndex + shift;
        return values[index >= values.length || index < 0 ? 0 : index];
    }

    @NotNull
    public static <T> T shifted(@NotNull List<T> values, int currentIndex, int shift) {
        int index = currentIndex + shift;
        if (index < 0) {
            return values.getLast();
        }
        return values.get(index >= values.size() ? 0 : index);
    }
}

