/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db.sql.query;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.db.config.DatabaseType;
import su.nightexpress.nightcore.db.connection.AbstractConnector;
import su.nightexpress.nightcore.db.connection.impl.SQLiteConnector;
import su.nightexpress.nightcore.db.sql.column.Column;
import su.nightexpress.nightcore.db.sql.column.ColumnType;
import su.nightexpress.nightcore.db.sql.query.impl.SelectQuery;
import su.nightexpress.nightcore.db.sql.query.type.AbstractQuery;
import su.nightexpress.nightcore.db.sql.util.SQLUtils;
import su.nightexpress.nightcore.util.Lists;

@Deprecated
public class SQLQueries {
    public static boolean hasTable(@NotNull AbstractConnector connector, @NotNull String table) {
        boolean bl;
        block8: {
            Connection connection = connector.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet tables = metaData.getTables(null, null, table, null);
                boolean has = tables.next();
                tables.close();
                bl = has;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public static boolean hasColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull Column column) {
        return SQLQueries.hasColumn(connector, table, column.getName());
    }

    /*
     * Exception decompiling
     */
    public static boolean hasColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull String columnName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addColumn(@NotNull AbstractConnector connector, @NotNull DatabaseType type, @NotNull String table, @NotNull Column column, @NotNull String defVal) {
        if (SQLQueries.hasColumn(connector, table, column)) {
            return;
        }
        StringBuilder builder = new StringBuilder().append("ALTER TABLE ").append(table).append(" ADD ").append(column.getName()).append(" ").append(column.formatType(type));
        if (connector instanceof SQLiteConnector || column.getType() != ColumnType.STRING) {
            builder.append(" DEFAULT ").append("'").append(defVal).append("'");
        }
        SQLQueries.executeSimpleQuery(connector, builder.toString());
    }

    public static void renameColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull Column column, @NotNull String toName) {
        SQLQueries.renameColumn(connector, table, column.getName(), toName);
    }

    public static void renameColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull String columnName, @NotNull String toName) {
        if (!SQLQueries.hasColumn(connector, table, columnName)) {
            return;
        }
        String sql = "ALTER TABLE " + table + " RENAME COLUMN " + columnName + " TO " + toName;
        SQLQueries.executeSimpleQuery(connector, sql);
    }

    public static void dropColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull Column column) {
        SQLQueries.dropColumn(connector, table, column.getName());
    }

    public static void dropColumn(@NotNull AbstractConnector connector, @NotNull String table, @NotNull String columnName) {
        if (!SQLQueries.hasColumn(connector, table, columnName)) {
            return;
        }
        String sql = "ALTER TABLE " + table + " DROP COLUMN " + columnName;
        SQLQueries.executeSimpleQuery(connector, sql);
    }

    public static void createTable(@NotNull AbstractConnector connector, @NotNull DatabaseType type, @NotNull String table, @NotNull List<Column> columns) {
        if (columns.isEmpty()) {
            return;
        }
        StringBuilder idBuilder = new StringBuilder(SQLUtils.escape("id")).append(" ").append(ColumnType.INTEGER.build(type, 11));
        if (type == DatabaseType.SQLITE) {
            idBuilder.append(" PRIMARY KEY AUTOINCREMENT");
        } else {
            idBuilder.append(" PRIMARY KEY AUTO_INCREMENT");
        }
        String columnNames = columns.stream().map(column -> column.getNameEscaped() + " " + column.formatType(type)).collect(Collectors.joining(", "));
        String allColumns = String.valueOf(idBuilder) + ", " + columnNames;
        String sql = "CREATE TABLE IF NOT EXISTS " + table + "(" + allColumns + ");";
        SQLQueries.executeSimpleQuery(connector, sql);
    }

    public static void renameTable(@NotNull AbstractConnector connector, @NotNull DatabaseType type, @NotNull String table, @NotNull String toName) {
        if (!SQLQueries.hasTable(connector, table)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        if (type == DatabaseType.MYSQL) {
            sql.append("RENAME TABLE ").append(table).append(" TO ").append(toName).append(";");
        } else {
            sql.append("ALTER TABLE ").append(table).append(" RENAME TO ").append(toName);
        }
        SQLQueries.executeSimpleQuery(connector, sql.toString());
    }

    public static void executeSimpleQuery(@NotNull AbstractConnector connector, @NotNull String sql) {
        try (Connection connection = connector.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    public static <T> void executeQuery(@NotNull AbstractConnector connector, @NotNull String table, @NotNull AbstractQuery<T> query, @NotNull T entity) {
        SQLQueries.executeQuery(connector, table, query, Lists.newList(entity));
    }

    public static <T> void executeQuery(@NotNull AbstractConnector connector, @NotNull String table, @NotNull AbstractQuery<T> query, @NotNull Collection<T> entities) {
        if (query.isEmpty()) {
            return;
        }
        String sql = query.createSQL(table);
        try (Connection connection = connector.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            int entityCount = 0;
            for (T entity : entities) {
                query.onExecute(statement, entity);
                statement.addBatch();
                if (++entityCount % 500 != 0 && entityCount != entities.size()) continue;
                statement.executeBatch();
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    @NotNull
    public static <T> List<T> executeSelect(@NotNull AbstractConnector connector, @NotNull String table, @NotNull SelectQuery<T> query) {
        ArrayList list = new ArrayList();
        if (query.isEmpty()) {
            return list;
        }
        String sql = query.createSQL(table);
        try (Connection connection = connector.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            query.onExecute(statement, list);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
        return list;
    }
}

