/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.database;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightDataPlugin;
import su.nightexpress.nightcore.core.CoreConfig;
import su.nightexpress.nightcore.database.AbstractUserDataHandler;
import su.nightexpress.nightcore.database.DataUser;
import su.nightexpress.nightcore.database.UserdataConfig;
import su.nightexpress.nightcore.database.listener.UserListener;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.Players;

@Deprecated
public abstract class AbstractUserManager<P extends NightDataPlugin<U>, U extends DataUser>
extends AbstractManager<P> {
    private final UserdataConfig config;
    private final Map<UUID, U> loadedById;
    private final Map<String, U> loadedByName;
    private final Map<UUID, U> scheduledSaves;

    public AbstractUserManager(@NotNull P plugin) {
        super(plugin);
        this.config = UserdataConfig.read(plugin);
        this.loadedById = new ConcurrentHashMap<UUID, U>();
        this.loadedByName = new ConcurrentHashMap<String, U>();
        this.scheduledSaves = new ConcurrentHashMap<UUID, U>();
    }

    @Override
    protected void onLoad() {
        this.addListener(new UserListener((NightDataPlugin)this.plugin));
        this.addTask(((NightDataPlugin)this.plugin).createAsyncTask(this::saveScheduled).setTicksInterval(this.config.getSaveInterval()));
    }

    @Override
    protected void onShutdown() {
        this.saveAll();
        this.getLoadedByIdMap().clear();
        this.getLoadedByNameMap().clear();
    }

    @NotNull
    private AbstractUserDataHandler<?, U> getDataHandler() {
        return ((NightDataPlugin)this.plugin).getData();
    }

    @NotNull
    public abstract U createUserData(@NotNull UUID var1, @NotNull String var2);

    public void loadOnlineUsers() {
        ((NightDataPlugin)this.plugin).getServer().getOnlinePlayers().stream().map(OfflinePlayer::getUniqueId).forEach(id -> {
            U user = this.getUserData((UUID)id);
            if (user != null) {
                this.cachePermanent(user);
            }
        });
    }

    public void saveScheduled() {
        if (this.scheduledSaves.isEmpty()) {
            return;
        }
        HashSet users = new HashSet();
        this.scheduledSaves.values().forEach(user -> {
            if (user.isAutoSaveReady()) {
                users.add(user);
            }
        });
        this.getDataHandler().saveUsers(users);
        users.forEach(user -> {
            user.cancelAutoSave();
            user.setNextSyncIn(this.config.getSaveSyncPause());
        });
        this.scheduledSaves.values().removeAll(users);
    }

    public void saveAll() {
        HashSet<U> users = new HashSet<U>();
        users.addAll(this.scheduledSaves.values());
        users.addAll(this.getLoaded());
        this.getDataHandler().saveUsers(users);
        this.scheduledSaves.values().forEach(DataUser::cancelAutoSave);
        this.scheduledSaves.clear();
    }

    @NotNull
    public final U getUserData(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        U user = this.getLoaded(uuid);
        if (user != null) {
            return user;
        }
        if (Players.isReal(player) && (user = this.getUserData(uuid)) != null) {
            return user;
        }
        return this.createUserData(uuid, player.getName());
    }

    @Nullable
    public final U getUserData(@NotNull String name) {
        Player player = Players.getPlayer(name);
        if (player != null) {
            return this.getUserData(player);
        }
        U user = this.getLoaded(name);
        if (user != null) {
            return user;
        }
        user = ((NightDataPlugin)this.plugin).getData().getUser(name);
        if (user != null) {
            user.onLoad();
            this.cacheTemporary(user);
        }
        return user;
    }

    @Nullable
    public final U getUserData(@NotNull UUID uuid) {
        U user = this.getLoaded(uuid);
        if (user != null) {
            return user;
        }
        user = ((NightDataPlugin)this.plugin).getData().getUser(uuid);
        if (user != null) {
            user.onLoad();
            this.cacheTemporary(user);
        }
        return user;
    }

    public final CompletableFuture<U> getUserDataAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> this.getUserData(name));
    }

    public final CompletableFuture<U> getUserDataAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.getUserData(uuid));
    }

    public void manageUser(@NotNull String name, Consumer<U> consumer) {
        this.manageUser(() -> this.getLoaded(name), () -> this.getUserDataAsync(name), consumer);
    }

    public void manageUser(@NotNull UUID playerId, Consumer<U> consumer) {
        this.manageUser(() -> this.getLoaded(playerId), () -> this.getUserDataAsync(playerId), consumer);
    }

    public void manageUserSynchronized(@NotNull String name, Consumer<U> consumer) {
        this.manageUserSynchronized(() -> this.getLoaded(name), () -> this.getUserDataAsync(name), consumer);
    }

    public void manageUserSynchronized(@NotNull UUID playerId, Consumer<U> consumer) {
        this.manageUserSynchronized(() -> this.getLoaded(playerId), () -> this.getUserDataAsync(playerId), consumer);
    }

    private void manageUser(@NotNull Supplier<U> loadedSupplier, @NotNull Supplier<CompletableFuture<U>> fetchSupplier, @NotNull Consumer<U> consumer) {
        DataUser user = (DataUser)loadedSupplier.get();
        if (user != null) {
            consumer.accept(user);
        } else {
            fetchSupplier.get().thenAccept((Consumer)consumer);
        }
    }

    private void manageUserSynchronized(@NotNull Supplier<U> loadedSupplier, @NotNull Supplier<CompletableFuture<U>> fetchSupplier, @NotNull Consumer<U> consumer) {
        this.manageUser(loadedSupplier, fetchSupplier, user -> ((NightDataPlugin)this.plugin).runTask(() -> consumer.accept(user)));
    }

    @Deprecated
    public void getUserDataAndPerform(@NotNull String name, Consumer<U> consumer) {
        this.manageUserSynchronized(name, consumer);
    }

    @Deprecated
    public void getUserDataAndPerform(@NotNull UUID uuid, Consumer<U> consumer) {
        this.manageUserSynchronized(uuid, consumer);
    }

    @Deprecated
    public void getUserDataAndPerformAsync(@NotNull String name, Consumer<U> consumer) {
        this.manageUser(name, consumer);
    }

    @Deprecated
    public void getUserDataAndPerformAsync(@NotNull UUID uuid, Consumer<U> consumer) {
        this.manageUser(uuid, consumer);
    }

    public final void unload(@NotNull Player player) {
        this.unload(player.getUniqueId());
    }

    public final void unload(@NotNull UUID uuid) {
        DataUser user = (DataUser)this.getLoadedByIdMap().get(uuid);
        if (user == null) {
            return;
        }
        this.unload(user);
    }

    public void unload(@NotNull U user) {
        Player player = user.getPlayer();
        if (player != null) {
            user.setName(player.getName());
            user.setLastOnline(System.currentTimeMillis());
        }
        if (this.isScheduledToSave(user)) {
            this.scheduledSaves.remove(user.getId());
        }
        ((NightDataPlugin)this.plugin).runTaskAsync(() -> this.save(user));
        this.cacheTemporary(user);
    }

    public void save(@NotNull U user) {
        ((NightDataPlugin)this.plugin).getData().saveUser(user);
    }

    public void scheduleSave(@NotNull U user) {
        user.setAutoSaveIn(this.config.getSaveDelay());
        user.cancelSynchronization();
        this.scheduledSaves.put(user.getId(), user);
    }

    public boolean isScheduledToSave(@NotNull U user) {
        return this.scheduledSaves.containsKey(user.getId());
    }

    @Deprecated
    public void saveAsync(@NotNull U user) {
        this.scheduleSave(user);
    }

    @NotNull
    public Set<U> getAllUsers() {
        HashMap users = new HashMap();
        this.getLoaded().forEach(user -> users.put(user.getId(), user));
        ((NightDataPlugin)this.plugin).getData().getUsers().forEach(user -> users.putIfAbsent(user.getId(), user));
        return new HashSet(users.values());
    }

    @NotNull
    public Map<UUID, U> getLoadedByIdMap() {
        this.removeExpired(this.loadedById.values());
        return this.loadedById;
    }

    @NotNull
    public Map<String, U> getLoadedByNameMap() {
        this.removeExpired(this.loadedByName.values());
        return this.loadedByName;
    }

    private void removeExpired(@NotNull Collection<U> collection) {
        collection.removeIf(user -> {
            if (user.isCacheExpired()) {
                user.onUnload();
                return true;
            }
            return false;
        });
    }

    @NotNull
    public Set<U> getLoaded() {
        return new HashSet<U>(this.getLoadedByIdMap().values());
    }

    @Nullable
    public U getLoaded(@NotNull UUID uuid) {
        return (U)((DataUser)this.getLoadedByIdMap().get(uuid));
    }

    @Nullable
    public U getLoaded(@NotNull String name) {
        return (U)((DataUser)this.getLoadedByNameMap().get(name.toLowerCase()));
    }

    public boolean isLoaded(@NotNull Player player) {
        return this.isLoaded(player.getUniqueId());
    }

    public boolean isLoaded(@NotNull UUID id) {
        return this.getLoadedByIdMap().containsKey(id);
    }

    public boolean isLoaded(@NotNull String name) {
        return this.getLoadedByNameMap().containsKey(name.toLowerCase());
    }

    public boolean isCreated(@NotNull String name) {
        return ((NightDataPlugin)this.plugin).getData().isUserExists(name);
    }

    public boolean isCreated(@NotNull UUID uuid) {
        return ((NightDataPlugin)this.plugin).getData().isUserExists(uuid);
    }

    public void cacheTemporary(@NotNull U user) {
        user.setCachedUntil(System.currentTimeMillis() + (long)CoreConfig.USER_CACHE_LIFETIME.get().intValue() * 1000L);
        this.cache(user);
    }

    public void cachePermanent(@NotNull U user) {
        user.setCachedUntil(-1L);
        this.cache(user);
    }

    private void cache(@NotNull U user) {
        this.getLoadedByIdMap().putIfAbsent(user.getId(), user);
        this.getLoadedByNameMap().putIfAbsent(user.getName().toLowerCase(), user);
    }
}

