/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.text.event;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.text.event.WrappedPayload;

public class NightClickEvent {
    private final Action action;
    private final WrappedPayload payload;

    public NightClickEvent(@NotNull Action action, @NotNull WrappedPayload payload) {
        this.action = action;
        this.payload = payload;
    }

    @NotNull
    public Action action() {
        return this.action;
    }

    @NotNull
    public WrappedPayload payload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NightClickEvent that = (NightClickEvent)other;
        return this.action == that.action && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public static enum Action {
        OPEN_URL("open_url"),
        OPEN_FILE("open_file"),
        RUN_COMMAND("run_command"),
        SUGGEST_COMMAND("suggest_command"),
        CHANGE_PAGE("change_page"),
        COPY_TO_CLIPBOARD("copy_to_clipboard"),
        SHOW_DIALOG("show_dialog"),
        CUSTOM("custom");

        private final String name;

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

