/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore;

import java.util.function.Consumer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEventHandler;
import su.nightexpress.nightcore.bridge.scheduler.AdaptedScheduler;
import su.nightexpress.nightcore.command.CommandManager;
import su.nightexpress.nightcore.command.api.NightPluginCommand;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.PluginDetails;
import su.nightexpress.nightcore.language.LangManager;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.ui.inventory.MenuRegistry;
import su.nightexpress.nightcore.util.wrapper.UniTask;

public interface NightCorePlugin
extends Plugin {
    public void enable();

    public void disable();

    public void reload();

    @Deprecated
    public NightPluginCommand getBaseCommand();

    @NotNull
    public FileConfig getConfig();

    @Deprecated
    @NotNull
    public FileConfig getLang();

    @NotNull
    public PluginDetails getDetails();

    public void extractResources(@NotNull String var1);

    public void extractResources(@NotNull String var1, @NotNull String var2);

    public void injectLang(@NotNull Class<? extends LangContainer> var1);

    public void injectLang(@NotNull LangContainer var1);

    @NotNull
    default public String getNameLocalized() {
        return this.getDetails().getName();
    }

    @NotNull
    default public String getPrefix() {
        return this.getDetails().getPrefix();
    }

    @NotNull
    default public String[] getCommandAliases() {
        return this.getDetails().getCommandAliases();
    }

    @Deprecated
    @NotNull
    default public String getLanguage() {
        return this.getDetails().getLanguage();
    }

    default public void info(@NotNull String msg) {
        this.getLogger().info(msg);
    }

    default public void warn(@NotNull String msg) {
        this.getLogger().warning(msg);
    }

    default public void error(@NotNull String msg) {
        this.getLogger().severe(msg);
    }

    default public void debug(@NotNull String msg) {
        this.info("[DEBUG] " + msg);
    }

    public void registerListener(@NotNull Listener var1);

    public void addChatHandler(@NotNull EventPriority var1, @NotNull UniversalChatEventHandler var2);

    public void removeChatHandler(@NotNull UniversalChatEventHandler var1);

    @Deprecated
    @NotNull
    public LangManager getLangManager();

    @Deprecated
    @NotNull
    public CommandManager getCommandManager();

    @NotNull
    public MenuRegistry getMenuRegistry();

    @Deprecated
    @NotNull
    default public BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @NotNull
    public AdaptedScheduler scheduler();

    @NotNull
    public PluginManager getPluginManager();

    public void runTask(@NotNull Runnable var1);

    public void runTask(Entity var1, @NotNull Runnable var2);

    public void runTask(Location var1, @NotNull Runnable var2);

    public void runTask(Chunk var1, @NotNull Runnable var2);

    public void runTaskAsync(@NotNull Runnable var1);

    public void runTaskLater(@NotNull Runnable var1, long var2);

    public void runTaskLaterAsync(@NotNull Runnable var1, long var2);

    public void runTaskTimer(@NotNull Runnable var1, long var2, long var4);

    public void runTaskTimerAsync(@NotNull Runnable var1, long var2, long var4);

    @Deprecated
    default public void runTask(@NotNull Consumer<BukkitTask> consumer) {
        this.getScheduler().runTask((Plugin)this, consumer);
    }

    @Deprecated
    default public void runTaskAsync(@NotNull Consumer<BukkitTask> consumer) {
        this.getScheduler().runTaskAsynchronously((Plugin)this, consumer);
    }

    @Deprecated
    default public void runTaskLater(@NotNull Consumer<BukkitTask> consumer, long delay) {
        this.getScheduler().runTaskLater((Plugin)this, consumer, delay);
    }

    @Deprecated
    default public void runTaskLaterAsync(@NotNull Consumer<BukkitTask> consumer, long delay) {
        this.getScheduler().runTaskLaterAsynchronously((Plugin)this, consumer, delay);
    }

    @Deprecated
    default public void runTaskTimer(@NotNull Consumer<BukkitTask> consumer, long delay, long interval) {
        this.getScheduler().runTaskTimer((Plugin)this, consumer, delay, interval);
    }

    @Deprecated
    default public void runTaskTimerAsync(@NotNull Consumer<BukkitTask> consumer, long delay, long interval) {
        this.getScheduler().runTaskTimerAsynchronously((Plugin)this, consumer, delay, interval);
    }

    @Deprecated
    @NotNull
    default public UniTask createTask(@NotNull Runnable runnable) {
        return new UniTask(this, runnable);
    }

    @Deprecated
    @NotNull
    default public UniTask createAsyncTask(@NotNull Runnable runnable) {
        return this.createTask(runnable).setAsync();
    }
}

