/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.LegacyColors;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.night.ParserMode;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.entry.EntryGroup;
import su.nightexpress.nightcore.util.text.night.tag.TagHandler;
import su.nightexpress.nightcore.util.text.night.tag.TagHandlerRegistry;
import su.nightexpress.nightcore.util.text.night.tag.TagPool;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class TextParser {
    public static final String ROOT_NAME = "root";
    private final TagPool tagPool;
    private final ParserMode mode;
    private final boolean legacyMode;
    private String string;
    private EntryGroup currentGroup;
    private StringBuilder eater;
    private NightComponent component;

    TextParser(@NotNull String string, @NotNull ParserMode mode, @NotNull TagPool tagPool) {
        this.mode = mode;
        this.tagPool = tagPool;
        this.legacyMode = true;
        this.setString(string);
        this.eater = new StringBuilder();
        this.currentGroup = new EntryGroup(ROOT_NAME);
    }

    @NotNull
    public static NightComponent parse(@NotNull String string) {
        return TextParser.parse(string, TagPool.ALL);
    }

    @NotNull
    public static NightComponent parse(@NotNull String string, @NotNull TagPool tagPool) {
        return TextParser.runParser((String)string, (ParserMode)ParserMode.PARSE, (TagPool)tagPool).component;
    }

    @NotNull
    public static String strip(@NotNull String string) {
        return TextParser.strip(string, TagPool.NONE);
    }

    @NotNull
    public static String strip(@NotNull String string, @NotNull TagPool tagPool) {
        return TextParser.runParser((String)string, (ParserMode)ParserMode.STRIP, (TagPool)tagPool).eater.toString();
    }

    @NotNull
    private static TextParser runParser(@NotNull String string, @NotNull ParserMode mode, @NotNull TagPool tagPool) {
        TextParser parser = new TextParser(string, mode, tagPool);
        parser.run();
        return parser;
    }

    private void setString(@NotNull String string) {
        if (this.legacyMode) {
            string = LegacyColors.plainColors(string);
            string = ParserUtils.wrapHexCodesAsTags(string);
        }
        this.string = string;
    }

    @NotNull
    public EntryGroup downward(@NotNull String childrenName) {
        this.consumeEaten();
        this.currentGroup = this.currentGroup.downward(childrenName);
        return this.currentGroup;
    }

    public void jumpToRoot() {
        this.upward(ROOT_NAME);
        this.upward();
    }

    @NotNull
    public EntryGroup backTo(@NotNull String parentName) {
        this.consumeEaten();
        this.currentGroup = this.currentGroup.backTo(parentName);
        return this.currentGroup;
    }

    @NotNull
    public EntryGroup upward(@NotNull String parentName) {
        this.consumeEaten();
        this.currentGroup = this.currentGroup.upward(parentName);
        return this.currentGroup;
    }

    @NotNull
    public EntryGroup upward() {
        this.consumeEaten();
        this.currentGroup = this.currentGroup.upward();
        return this.currentGroup;
    }

    public void consumeEaten() {
        if (this.mode == ParserMode.STRIP) {
            return;
        }
        if (!this.eater.isEmpty()) {
            this.currentGroup.appendTextEntry(this.eater.toString());
        }
        this.eater = new StringBuilder();
    }

    private void eat(char c) {
        this.eater.append(c);
    }

    private void eat(@NotNull String string) {
        this.eater.append(string);
    }

    public void run() {
        int length = this.string.length();
        int lastIndex = length - 1;
        int tagEndIndex = -1;
        boolean isEscaped = false;
        boolean isTagEntered = false;
        boolean isTagClosing = false;
        boolean isLegacyChar = false;
        for (int index = 0; index < length; ++index) {
            String tagContent;
            String tagName;
            int semicolonIndex;
            String bracketsContent;
            char letter = this.string.charAt(index);
            if (isEscaped) {
                isEscaped = false;
                isTagEntered = false;
                isTagClosing = false;
                isLegacyChar = false;
                this.eat(letter);
                continue;
            }
            if (letter == '\\') {
                isEscaped = true;
                if (this.mode != ParserMode.STRIP) continue;
                this.eat(letter);
                continue;
            }
            if (!isTagEntered) {
                if (!isLegacyChar) {
                    if (letter == '&' && this.legacyMode) {
                        isLegacyChar = true;
                        isTagEntered = true;
                        continue;
                    }
                    if (letter != '<' || index == lastIndex) {
                        this.eat(letter);
                        continue;
                    }
                    tagEndIndex = ParserUtils.findUnescapedUnquotedUnprecededByChar(this.string, '>', Character.valueOf('<'), index + 1);
                    if (tagEndIndex == -1) {
                        this.eat(letter);
                        continue;
                    }
                }
                isTagEntered = true;
                continue;
            }
            if (!isTagClosing && letter == '/') {
                isTagClosing = true;
                continue;
            }
            SimpleTagWrapper legacyWrapper = null;
            if (isLegacyChar && (legacyWrapper = ParserUtils.legacyToNamedWrapper(letter)) == null) {
                isTagEntered = false;
                isLegacyChar = false;
                this.eat('&');
                this.eat(letter);
                continue;
            }
            if (legacyWrapper != null) {
                bracketsContent = legacyWrapper.openingNoBrackets();
                tagEndIndex = index;
            } else {
                bracketsContent = this.string.substring(index, tagEndIndex);
            }
            if (bracketsContent.startsWith("#")) {
                bracketsContent = TagWrappers.COLOR.with(bracketsContent).openingNoBrackets();
            }
            if ((semicolonIndex = bracketsContent.indexOf(58)) >= 0) {
                tagName = LowerCase.INTERNAL.apply(bracketsContent.substring(0, semicolonIndex));
                tagContent = bracketsContent.substring(semicolonIndex + 1);
            } else {
                tagName = LowerCase.INTERNAL.apply(bracketsContent);
                tagContent = null;
            }
            TagHandler handler = TagHandlerRegistry.create(tagName);
            if (handler == null) {
                --index;
                isTagEntered = false;
                this.eat('<');
                continue;
            }
            if (this.tagPool.isGoodTag(handler)) {
                if (this.mode == ParserMode.STRIP) {
                    this.eat(isTagClosing ? TagWrapper.simple(tagName).closing() : TagWrapper.simple(bracketsContent).opening());
                } else if (this.mode == ParserMode.PARSE) {
                    String groupName = LowerCase.INTERNAL.apply(tagName);
                    if (isTagClosing) {
                        this.backTo(groupName);
                        resolvers = this.currentGroup.getResolvers();
                        resolver = resolvers.removeFor(tagName);
                        if (resolver != null && resolver.canBeClosed()) {
                            resolver.handleClose(this.currentGroup);
                            this.upward();
                        }
                    } else {
                        this.downward(groupName);
                        resolvers = this.currentGroup.getResolvers();
                        resolver = resolvers.createFor(tagName);
                        if (resolver != null) {
                            resolver.handleOpen(this.currentGroup, tagContent);
                            if (!resolver.canBeClosed()) {
                                this.upward();
                            }
                        }
                    }
                }
            }
            isTagEntered = false;
            isTagClosing = false;
            isLegacyChar = false;
            index = tagEndIndex;
        }
        this.jumpToRoot();
        this.currentGroup.getChildGroups().forEach(EntryGroup::closeResolvers);
        this.jumpToRoot();
        this.component = this.currentGroup.toComponent();
        this.currentGroup = null;
    }

    @NotNull
    public String getString() {
        return this.string;
    }

    @NotNull
    public EntryGroup getCurrentGroup() {
        return this.currentGroup;
    }
}

