/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Randomizer;
import su.nightexpress.nightcore.util.loot.LootEntry;

public class LootTable<T, C> {
    private final List<LootEntry<T, C>> entries = new ArrayList<LootEntry<T, C>>();
    private final RandomGenerator rnd;

    public LootTable(@NotNull RandomGenerator rnd) {
        this.rnd = rnd;
    }

    @NotNull
    public static <T, C> LootTable<T, C> create() {
        return new LootTable<T, C>(Randomizer.getSource());
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @NotNull
    public Optional<T> pick(@NotNull C context) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        double totalWeight = 0.0;
        ArrayList<LootEntry<T, C>> allowed = new ArrayList<LootEntry<T, C>>(this.entries.size());
        for (LootEntry<T, C> entry : this.entries) {
            if (!entry.canPick(context)) continue;
            totalWeight += entry.weight();
            allowed.add(entry);
        }
        double randomValue = this.rnd.nextDouble(totalWeight);
        for (LootEntry lootEntry : allowed) {
            if (!((randomValue -= lootEntry.weight()) <= 0.0)) continue;
            return Optional.of(lootEntry.item());
        }
        return Optional.empty();
    }

    @NotNull
    public LootTable<T, C> add(@NotNull T item, double weight) {
        this.entries.add(LootEntry.of(item, weight));
        return this;
    }

    @NotNull
    public LootTable<T, C> add(@NotNull T item, double weight, @NotNull Predicate<C> predicate) {
        this.entries.add(LootEntry.of(item, weight, predicate));
        return this;
    }
}

