/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Randomizer;
import su.nightexpress.nightcore.util.random.MTRandom;
import su.nightexpress.nightcore.util.random.WeightedItem;

public class Rnd {
    public static final MTRandom RANDOM = new MTRandom();

    public static float getChance() {
        return Rnd.nextFloat() * 100.0f;
    }

    public static int get(int n) {
        return Rnd.nextInt(n);
    }

    public static int get(int min, int max) {
        return min + (int)Math.floor(RANDOM.nextDouble() * (double)(max - min + 1));
    }

    public static double getDouble(double max) {
        return Rnd.getDouble(0.0, max);
    }

    public static double getDouble(double min, double max) {
        return min + (max - min) * RANDOM.nextDouble();
    }

    @NotNull
    public static <E> E get(@NotNull E[] list) {
        return list[Rnd.get(list.length)];
    }

    public static int get(int[] list) {
        return list[Rnd.get(list.length)];
    }

    @NotNull
    public static <E> E get(@NotNull List<E> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException("Empty list provided!");
        }
        return list.get(Rnd.get(list.size()));
    }

    @NotNull
    public static <E> E get(@NotNull Set<E> list) {
        return Rnd.get(new ArrayList<E>(list));
    }

    @NotNull
    public static <T> T getByWeight(@NotNull Map<T, Double> itemsMap) {
        ArrayList items = new ArrayList();
        itemsMap.forEach((item, weight) -> items.add(WeightedItem.of(item, weight)));
        return Rnd.getByWeight(items);
    }

    @NotNull
    public static <T> T getByWeight(@NotNull List<WeightedItem<T>> items) {
        double totalWeight = items.stream().mapToDouble(WeightedItem::getWeight).sum();
        double randomValue = Randomizer.nextDouble(totalWeight);
        for (WeightedItem<T> entry : items) {
            if (!((randomValue -= entry.getWeight()) <= 0.0)) continue;
            return entry.getItem();
        }
        throw new IllegalStateException("No element found");
    }

    public static boolean chance(int chance) {
        return chance >= 1 && (chance > 99 || Rnd.nextInt(99) + 1 <= chance);
    }

    public static boolean chance(double chance) {
        return Rnd.nextDouble() <= chance / 100.0;
    }

    public static int nextInt(int bound) {
        return RANDOM.nextInt(bound);
    }

    public static int nextInt() {
        return RANDOM.nextInt();
    }

    public static double nextDouble() {
        return RANDOM.nextDouble();
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static double nextGaussian() {
        return RANDOM.nextGaussian();
    }

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }
}

